<?php
/**
 * Handle plugin installation upon activation.
 *
 * @package wpsyncsheets-for-elementor
 */

use ElementorPro\Plugin;
use Elementor\Controls_Manager;
use ElementorPro\Modules\Forms\Module;
use WPSyncSheets_Elementor\WPSSE_Google_API_Functions;
/**
 * Class WPSSE_Plugin_Setting.
 *
 * @since 1.0.0
 */
class WPSSE_Plugin_Setting {

	/**
	 * Instance of Plugin_Settings
	 *
	 * @var $instance
	 */
	private static $instance = null;

	/**
	 * Instance of WPSSE_Feed_Settings
	 *
	 * @var $instanceaddon
	 */
	private static $instanceaddon = null;

	/**
	 * Instance of Google_API_Functions
	 *
	 * @var $instance_api
	 */
	private static $instance_api = null;
	/**
	 * Plugin License Page URL
	 *
	 * @var $wpsse_license_page
	 */
	protected static $wpsse_license_page = 'wpsyncsheets-for-elementor&tab=em-settings';
	/**
	 * Register Link
	 *
	 * @var $wpsse_register_link
	 */
	protected static $wpsse_register_link = 'https://www.wpsyncsheets.com/checkout/?edd_action=add_to_cart&download_id=1386&discount=ENVATO100&pm=codecanyon';

	/**
	 * Plugin Store URL
	 *
	 * @var $wpsse_store_url
	 */
	protected static $wpsse_store_url = WPSSE_STORE_URL;
	/**
	 * Initialization
	 */
	public static function wpsse_initilization() {
		register_activation_hook( WPSSE_BASE_FILE, __CLASS__ . '::wpsse_activation' );
		register_deactivation_hook( WPSSE_BASE_FILE, __CLASS__ . '::wpsse_deactivation' );
		add_action( 'admin_print_styles', __CLASS__ . '::wpsse_add_css_files' );
		add_action( 'admin_menu', __CLASS__ . '::wpsse_menu_page', 20 );
		add_action( 'elementor/editor/after_enqueue_scripts', __CLASS__ . '::wpsse_load_wp_admin_style' );
		add_action( 'admin_enqueue_scripts', __CLASS__ . '::wpsse_selectively_enqueue_admin_script' );
		add_action( 'admin_enqueue_scripts', __CLASS__ . '::wpsse_load_wp_admin_style' );
		add_filter( 'plugin_row_meta', __CLASS__ . '::wpsse_plugin_row_meta', 10, 2 );
		add_action( 'elementor_pro/init', __CLASS__ . '::wpsse_init' );
		add_action( 'elementor/ajax/register_actions', __CLASS__ . '::wpsse_ajax_register_action' );
		add_action( 'elementor/editor/after_save', __CLASS__ . '::wpsse_after_save_settings', 9999, 2 );
		add_action( 'elementor/template-library/after_update_template', __CLASS__ . '::wpsse_after_update_template', 9999, 2 );
		add_action( 'admin_notices', __CLASS__ . '::wpsse_license_notice' );
		add_action( 'wp_ajax_wpsse_reset_settings', __CLASS__ . '::wpsse_reset_settings' );
		add_action( 'wp_ajax_wpsse_sync_data', __CLASS__ . '::wpsse_sync_data' );
		add_action( 'wp_ajax_wpsse_clear_data', __CLASS__ . '::wpsse_clearsheet' );
		self::wpsse_google_api();
		self::instance();
		self::wpsse_license()->init();
	}

	/**
	 * Main WPSSE_Plugin_Settings Instance.
	 *
	 * @since 1.0.0
	 *
	 * @return instance
	 */
	public static function instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Create WPSSE_Feed_Settings Class Instance.
	 */
	public static function get_addoninstance() {
		if ( null === self::$instanceaddon ) {
			self::$instanceaddon = new \WPSSE_Feed_Settings();
		}
		return self::$instanceaddon;
	}

	/**
	 * Create Google Api Instance.
	 */
	public static function wpsse_google_api() {

		if ( null === self::$instance_api ) {
			self::$instance_api = new WPSSE_Google_API_Functions();
		}
		return self::$instance_api;
	}
	/**
	 * Enqueue css files
	 */
	public static function wpsse_add_css_files() {
		wp_register_style( 'wpsse-wp-general-notice', WPSSE_URL . 'assets/css/wpsse-general-notice-style.css', false, WPSSE_VERSION );
		wp_enqueue_style( 'wpsse-wp-general-notice' );
	}
	/**
	 * Plugin Activation Hook
	 */
	public static function wpsse_activation() {
		update_option( 'active_wpsyncsheets_elementor', 1 );
	}
	/**
	 * Plugin Deactivation Hook
	 */
	public static function wpsse_deactivation() {
		update_option( 'active_wpsyncsheets_elementor', '' );
	}

	/**
	 * LICENSE functions
	 */
	public static function wpsse_license() {
		return WPSSE_License::instance();
	}
	/**
	 * Ajax - Clear Sheet.
	 */
	public static function wpsse_clearsheet() {
		if ( ! isset( $_POST['sync_nonce_token'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['sync_nonce_token'] ) ), 'sync_nonce' )
		) {
			echo esc_html__( 'Error: Sorry, your nonce did not verify.', 'wpsse' );
			wp_die();
		}

		if ( ! isset( $_POST['post_id'] ) || empty( $_POST['post_id'] ) ) {
			echo esc_html__( 'Post id not found, reload this page and try again.', 'wpsse' );
			wp_die();
		}
		if ( isset( $_POST['post_id'] ) ) {
			$wpsse_post_id = sanitize_text_field( wp_unslash( $_POST['post_id'] ) );
		}
		$wpsse_saved_data = get_post_meta( $wpsse_post_id, '_elementor_data' );
		$wpsse_data       = json_decode( $wpsse_saved_data[0], true );

		$wpsse_prepared_data = self::$instance->wpsse_prepare_data( $wpsse_data );
		$wpsse_sheetname     = $wpsse_prepared_data['wpsse_sheetname'];
		$wpsse_spreadsheetid = $wpsse_prepared_data['wpsse_spreadsheetid'];

		$wpsse_sheetarray = self::wpsse_list_googlespreedsheet();
		if ( ( ! empty( $wpsse_spreadsheetid ) && ! array_key_exists( $wpsse_spreadsheetid, $wpsse_sheetarray ) ) || 'new' === (string) $wpsse_spreadsheetid ) {
			echo esc_html__( 'Please save your settings first and try again.', 'wpsse' );
			wp_die();
		} elseif ( empty( $wpsse_spreadsheetid ) || empty( $wpsse_sheetname ) ) {
			echo esc_html__( 'Please save your settings first and try again.', 'wpsse' );
			wp_die();
		}
		if ( ! empty( $wpsse_spreadsheetid ) ) {
			$response = self::$instance_api->get_sheet_listing( $wpsse_spreadsheetid );
			foreach ( $response->getSheets() as $s ) {
				$wpsse_sheets[] = $s['properties']['title'];
			}
			if ( ! empty( $wpsse_sheetname ) && ! in_array( $wpsse_sheetname, $wpsse_sheets, true ) ) {
				echo esc_html__( 'Please save your settings first and try again.', 'wpsse' );
				wp_die();
			}
		}
		$last_column = self::$instance->wpsse_get_column_index( count( $wpsse_prepared_data['wpsse_headers'] ) + 2 );

		$wpsse_existingsheetsnames = array();

		$response                  = self::$instance_api->get_sheet_listing( $wpsse_spreadsheetid );
		$wpsse_existingsheetsnames = self::$instance_api->get_sheetname_list( $response );

		if ( in_array( $wpsse_sheetname, $wpsse_existingsheetsnames, true ) ) {
			try {
				$range                  = $wpsse_sheetname . '!A2:' . $last_column . '10000';
				$requestbody            = self::$instance_api->clearobject();
				$param                  = array();
				$param['spreadsheetid'] = $wpsse_spreadsheetid;
				$param['sheetname']     = $range;
				$param['requestbody']   = $requestbody;
				$response               = self::$instance_api->clear( $param );
			} catch ( Exception $e ) {
				echo esc_html( $e->getMessage() );
			}
		}
		echo 'success';
		wp_die();
	}

	/**
	 * Get Column Index based on given number.
	 *
	 * @param int $number Index Number.
	 */
	public static function wpsse_get_column_index( $number ) {
		if ( $number <= 0 ) {
			return null;
		}

		$temp;
		$letter = '';
		while ( $number > 0 ) {
			$temp   = ( $number - 1 ) % 26;
			$letter = chr( $temp + 65 ) . $letter;
			$number = ( $number - $temp - 1 ) / 26;
		}
		return $letter;
	}

	/**
	 * Ajax - Sync Existing Entries to Google Spreadsheet.
	 */
	public static function wpsse_sync_data() {

		if ( ! isset( $_POST['sync_nonce_token'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['sync_nonce_token'] ) ), 'sync_nonce' )
		) {
			echo esc_html__( 'Error: Sorry, your nonce did not verify.', 'wpsse' );
			wp_die();
		}

		if ( ! isset( $_POST['post_id'] ) || empty( $_POST['post_id'] ) || ! isset( $_POST['form_id'] ) || empty( $_POST['form_id'] ) ) {
			echo esc_html__( 'Form id not found, reload this page and try again.', 'wpsse' );
			wp_die();
		}
		$wpsse_post_id = sanitize_text_field( wp_unslash( $_POST['post_id'] ) );
		$wpsse_form_id = sanitize_text_field( wp_unslash( $_POST['form_id'] ) );

		$wpsse_saved_data    = get_post_meta( $wpsse_post_id, '_elementor_data' );
		$wpsse_data          = json_decode( $wpsse_saved_data[0], true );
		$wpsse_prepared_data = self::$instance->wpsse_prepare_data( $wpsse_data );

		$wpsse_sheetname     = $wpsse_prepared_data['wpsse_sheetname'];
		$wpsse_spreadsheetid = $wpsse_prepared_data['wpsse_spreadsheetid'];

		$wpsse_sheetarray = self::wpsse_list_googlespreedsheet();
		if ( ( ! empty( $wpsse_spreadsheetid ) && ! array_key_exists( $wpsse_spreadsheetid, $wpsse_sheetarray ) ) || 'new' === (string) $wpsse_spreadsheetid ) {
			echo esc_html__( 'Please save your settings first and try again.', 'wpsse' );
			wp_die();
		} elseif ( empty( $wpsse_spreadsheetid ) || empty( $wpsse_sheetname ) ) {
			echo esc_html__( 'Please save your settings first and try again.', 'wpsse' );
			wp_die();
		}
		if ( ! empty( $wpsse_spreadsheetid ) ) {
			$response = self::$instance_api->get_sheet_listing( $wpsse_spreadsheetid );
			foreach ( $response->getSheets() as $s ) {
				$wpsse_sheets[] = $s['properties']['title'];
			}
			if ( ! empty( $wpsse_sheetname ) && ! in_array( $wpsse_sheetname, $wpsse_sheets, true ) ) {
				echo esc_html__( 'Please save your settings first and try again.', 'wpsse' );
				wp_die();
			}
		}

		global $wpdb;
		$wpsse_table_values = $wpdb->prefix . 'e_submissions_values';
		$wpsse_table        = $wpdb->prefix . 'e_submissions';
		// @codingStandardsIgnoreStart
		$wpsse_entries      = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT v.*, es.created_at, es.referer FROM $wpsse_table_values as v, $wpsse_table as es WHERE es.element_id = %d AND es.id= v.submission_id",
				(int) $wpsse_form_id
			),
			ARRAY_A
		);
		// @codingStandardsIgnoreEnd
		if ( empty( $wpsse_entries ) ) {
			echo esc_html( 'notfound' );
			wp_die();
		}

		$wpsse_headers         = $wpsse_prepared_data['wpsse_headers'];
		$lead_created_date     = $wpsse_prepared_data['lead_created_date'];
		$lead_created_page_url = $wpsse_prepared_data['lead_created_page_url'];
		$wpsse_existid         = array();

		$wpsse_range    = trim( $wpsse_sheetname ) . '!A1:ZZ1';
		$wpsse_response = self::$instance_api->get_row_list( $wpsse_spreadsheetid, $wpsse_range );
		$wpssepre_data  = $wpsse_response->getValues();

		$wpsse_prevoius_headers = isset( $wpssepre_data[0] ) ? $wpssepre_data[0] : array();

		if ( in_array( (string) 'Submission Date', $wpsse_prevoius_headers, true ) && in_array( (string) 'Page Referer Url', $wpsse_prevoius_headers, true ) ) {
			$wpsse_date_index = array_search( 'Submission Date', $wpsse_prevoius_headers, true );
			$wpsse_url_index  = array_search( 'Page Referer Url', $wpsse_prevoius_headers, true );

			if ( $wpsse_date_index < $wpsse_url_index ) {
				$wpsse_headers[] = 'created_at';
				$wpsse_headers[] = 'referer';
			} else {
				$wpsse_headers[] = 'referer';
				$wpsse_headers[] = 'created_at';
			}
		}
		$wpsse_master_array = array();

		foreach ( $wpsse_entries as $ekey => $evalue ) {
			if ( ! in_array( $evalue['submission_id'], $wpsse_existid, true ) ) {
				$wpsse_existid[] = $evalue['submission_id'];
				$wpsse_id        = $evalue['submission_id'];
				if ( ! empty( $wpsse_last_key ) ) {

					if ( 'yes' === (string) $lead_created_date ) {
						$wpsse_master_array[ $wpsse_previous_id ]['created_at'] = self::wpsse_get_date( strtotime( $wpsse_created_at ) );
					} else {
						if ( in_array( 'Submission Date', $wpsse_prevoius_headers, true ) ) {
							$wpsse_master_array[ $wpsse_previous_id ]['created_at'] = '';
						}
					}
					if ( 'yes' === (string) $lead_created_page_url ) {
						$wpsse_master_array[ $wpsse_previous_id ]['referer'] = $wpsse_referer;
					} else {
						if ( in_array( 'Page Referer Url', $wpsse_prevoius_headers, true ) ) {
							$wpsse_master_array[ $wpsse_previous_id ]['referer'] = '';
						}
					}
				}
			}
			if ( in_array( $evalue['key'], $wpsse_headers, true ) ) {
				$wpsse_master_array[ $wpsse_id ][ $evalue['key'] ] = $evalue['value'];
			}

			$wpsse_last_key    = $evalue['key'];
			$wpsse_created_at  = $evalue['created_at'];
			$wpsse_referer     = $evalue['referer'];
			$wpsse_previous_id = $wpsse_id;

		}
		if ( 'yes' === (string) $lead_created_date ) {
			$wpsse_master_array[ $wpsse_previous_id ]['created_at'] = self::wpsse_get_date( strtotime( $wpsse_created_at ) );
		} else {
			if ( in_array( 'Submission Date', $wpsse_prevoius_headers, true ) ) {
				$wpsse_master_array[ $wpsse_previous_id ]['created_at'] = '';
			}
		}
		if ( 'yes' === (string) $lead_created_page_url ) {
			$wpsse_master_array[ $wpsse_previous_id ]['referer'] = $wpsse_referer;
		} else {
			if ( in_array( 'Page Referer Url', $wpsse_prevoius_headers, true ) ) {
				$wpsse_master_array[ $wpsse_previous_id ]['referer'] = '';
			}
		}
		$wpsse_values = array();
		foreach ( $wpsse_master_array as $ekey => &$evalue ) {
			$temp = array();
			foreach ( $wpsse_headers as $k => $v ) {
				if ( isset( $evalue[ $v ] ) ) {
					$temp[] = $evalue[ $v ];
				} else {
					$temp[] = '';
				}
			}
			$wpsse_values[] = $temp;
		}
		$wpsse_sheet    = $wpsse_sheetname;
		$wpsse_allentry = self::$instance_api->get_row_list( $wpsse_spreadsheetid, $wpsse_sheet );
		$wpsse_data     = $wpsse_allentry->getValues();

		$wpsse_data = array_map(
			function ( $wpsse_element ) {
				if ( isset( $wpsse_element['0'] ) ) {
					return $wpsse_element['0'];
				} else {
					return '';
				}
			},
			$wpsse_data
		);

		if ( ! empty( $wpsse_master_array ) ) {
			try {
				$wpsse_master_array = array_values( $wpsse_values );
				$rangetofind        = $wpsse_sheetname . '!A' . ( count( $wpsse_data ) + 1 );

				$wpsse_requestbody = self::$instance_api->valuerangeobject( $wpsse_master_array );

				$wpsse_params = self::$instance->get_row_format();
				$param        = self::$instance_api->setparamater( $wpsse_spreadsheetid, $rangetofind, $wpsse_requestbody, $wpsse_params );
				$response     = self::$instance_api->updateentry( $param );
				echo esc_html( 'success' );
				wp_die();
			} catch ( Exception $e ) {
				echo esc_html( 'error' );
				wp_die();
			}
		}
		echo esc_html( 'success' );
		wp_die();
	}

	/**
	 * Action fire after Save from Elementor Editor.
	 *
	 * @param int   $wpsse_post_id Post ID.
	 * @param array $wpsse_formdata Template Data.
	 */
	public static function wpsse_after_save_settings( $wpsse_post_id, $wpsse_formdata ) {
		global $wpsse_exclude_headertype;
		$wpsse_exclude_headertype = array( 'honeypot', 'recaptcha', 'recaptcha_v3', 'html' );
		// phpcs:ignore
		if ( ! isset( $_REQUEST['actions'] ) || empty( $_REQUEST['actions'] ) ) {
			return;
		}
		// phpcs:ignore
		$wpsse_data = json_decode( sanitize_text_field( wp_unslash( $_REQUEST['actions'] ) ) , true );

		global $exist;
		$exist = 'no';
		global $existincurrentpage;
		$existincurrentpage = 'no';

		array_walk_recursive(
			$wpsse_data,
			function ( &$value, $key ) {
				if ( 'elementorsheets' === (string) $value ) {
					global $exist;
					$exist = 'yes';
				}
			}
		);

		if ( 'yes' === (string) $exist ) {

			global $wpsse_header_list, $wpsse_spreadsheetid, $wpsse_exclude_headertype, $wpsse_newsheetname, $wpsse_sheetname,$wpsse_sheetheaders, $wpsse_lead_created_page_url, $wpsse_freeze, $wpsse_lead_submission_date;
			$wpsse_lead_submission_date  = false;
			$wpsse_lead_created_page_url = false;
			$wpsse_freeze                = 0;
			$wpsse_header_list           = array();

			$wpsse_header_list = self::$instance->wpsse_get_headers( $wpsse_data );

			if ( ! $wpsse_header_list ) {
				$wpsse_header_list = array();
			}

			array_walk_recursive(
				$wpsse_data,
				function ( &$value, $key ) {

					global $wpsse_header_list, $wpsse_spreadsheetid, $wpsse_newsheetname, $wpsse_sheetname, $wpsse_freeze, $wpsse_lead_created_page_url, $wpsse_lead_submission_date;

					if ( 'spreadsheetid' === (string) $key ) {
						$wpsse_spreadsheetid = $value;
					}

					if ( 'new_spreadsheet_name' === (string) $key ) {
						$wpsse_newsheetname = $value;
					}

					if ( 'sheet_name' === (string) $key ) {
							$wpsse_sheetname = $value;
					}

					if ( 'lead_created_date' === (string) $key ) {
							$wpsse_lead_submission_date = true;
					}

					if ( 'lead_created_page_url' === (string) $key ) {
							$wpsse_lead_created_page_url = true;
					}

					if ( 'freeze_header' === (string) $key ) {
							$wpsse_freeze = 1;
					}
				}
			);

			$is_new = false;
			if ( 'new' === (string) $wpsse_spreadsheetid ) {

				$is_new              = true;
				$wpsse_newsheetname  = trim( $wpsse_newsheetname );
				$requestbody         = self::$instance_api->createspreadsheetobject( $wpsse_newsheetname );
				$wpsse_response      = self::$instance_api->createspreadsheet( $requestbody );
				$wpsse_spreadsheetid = $wpsse_response['spreadsheetId'];
			}

			$wpsse_existingsheetsnames = array();
			$response                  = self::$instance_api->get_sheet_listing( $wpsse_spreadsheetid );
			$wpsse_existingsheetsnames = self::$instance_api->get_sheetname_list( $response );

			if ( ! in_array( $wpsse_sheetname, $wpsse_existingsheetsnames, true ) ) {

				if ( $wpsse_lead_submission_date ) {
					$wpsse_header_list[] = 'Submission Date';
				}

				if ( $wpsse_lead_created_page_url ) {
					$wpsse_header_list[] = 'Page Referer Url';
				}
				$wpsse_body = self::$instance_api->createsheetobject( $wpsse_sheetname );

				try {
					$requestobject                  = array();
					$requestobject['spreadsheetid'] = $wpsse_spreadsheetid;
					$requestobject['requestbody']   = $wpsse_body;
					self::$instance_api->formatsheet( $requestobject );

				} catch ( Exception $e ) {
					echo esc_html( $e->getMessage() );
				}

				/**
				 * Insert Sheet Headers into sheet
				 */
				$wpsse_header_list = array_values( array_unique( $wpsse_header_list ) );

				$wpsse_range       = trim( $wpsse_sheetname ) . '!A1';
				$wpsse_requestbody = self::$instance_api->valuerangeobject( array( $wpsse_header_list ) );
				$wpsse_params      = self::$instance->get_row_format();
				$param             = self::$instance_api->setparamater( $wpsse_spreadsheetid, $wpsse_range, $wpsse_requestbody, $wpsse_params );
				self::$instance_api->appendentry( $param );

				if ( $is_new ) {
					$wpsse_requestbody              = self::$instance_api->deletesheetobject();
					$requestobject                  = array();
					$requestobject['spreadsheetid'] = $wpsse_spreadsheetid;
					$requestobject['requestbody']   = $wpsse_requestbody;
					self::$instance_api->formatsheet( $requestobject );
				}
			} else {
				$wpsse_header_list = array_values( array_unique( $wpsse_header_list ) );

				$wpsse_range    = trim( $wpsse_sheetname ) . '!A1:ZZ1';
				$wpsse_response = self::$instance_api->get_row_list( $wpsse_spreadsheetid, $wpsse_range );
				$wpsse_data     = $wpsse_response->getValues();

				$wpsse_prevoius_headers = isset( $wpsse_data[0] ) ? $wpsse_data[0] : array();

				if ( ! in_array( 'Submission Date', $wpsse_prevoius_headers, true ) ) {
					if ( $wpsse_lead_submission_date ) {
						if ( in_array( 'Page Referer Url', $wpsse_prevoius_headers, true ) ) {
							$wpsse_header_list[] = 'Page Referer Url';
						}
						$wpsse_header_list[] = 'Submission Date';
					}
				}
				if ( ! in_array( 'Page Referer Url', $wpsse_prevoius_headers, true ) ) {
					if ( $wpsse_lead_created_page_url ) {
						if ( in_array( 'Submission Date', $wpsse_prevoius_headers, true ) ) {
							$wpsse_header_list[] = 'Submission Date';
						}
						$wpsse_header_list[] = 'Page Referer Url';
					}
				}

				$wpsse_range = trim( $wpsse_sheetname ) . '!A1';

				$wpsse_requestbody = self::$instance_api->valuerangeobject( array( $wpsse_header_list ) );
				$wpsse_params      = self::$instance->get_row_format();
				$param             = self::$instance_api->setparamater( $wpsse_spreadsheetid, $wpsse_range, $wpsse_requestbody, $wpsse_params );
				self::$instance_api->updateentry( $param );
			}
			self::$instance->wpsse_freeze_header( $wpsse_spreadsheetid, $wpsse_sheetname, $wpsse_freeze );
		}
		$wpsse_saved_data = get_post_meta( $wpsse_post_id, '_elementor_data' );
		$wpsse_data11     = json_decode( $wpsse_saved_data[0], true );

		array_walk_recursive(
			$wpsse_data11,
			function ( &$existvalue, $existkey ) {
				if ( 'elementorsheets' === (string) $existvalue ) {
					global $existincurrentpage;
					$existincurrentpage = 'yes';
				}
			}
		);
		global $elementorsheet_is_enable, $globalformdata, $formmetaid;

		array_walk_recursive(
			$wpsse_data11,
			function ( &$value, $key ) {

				global $existincurrentpage, $wpsse_spreadsheetid, $elementorsheet_is_enable;

				if ( 'yes' === (string) $existincurrentpage ) {

					if ( 'spreadsheetid' === (string) $key ) {
						$value = $wpsse_spreadsheetid;
					}
					if ( 'new_spreadsheet_name' === (string) $key || 'header_name' === (string) $key ) {
						$value = '';
					}
				} else {
					if ( 'templateID' === (string) $key ) {

						$form = get_post_meta( $value, '_elementor_template_widget_type' );

						if ( in_array( 'form', $form, true ) ) {
							global $globalformdata, $elementorsheet_is_enable;
							$formdata                 = get_post_meta( $value, '_elementor_data' );
							$globalformdata           = json_decode( $formdata[0], true );
							$elementorsheet_is_enable = 0;
							array_walk_recursive(
								$globalformdata,
								function ( &$formvalue, $formkey ) {
									global $wpsse_spreadsheetid, $elementorsheet_is_enable;

									if ( 'spreadsheetid' === (string) $formkey ) {
										$formvalue                = $wpsse_spreadsheetid;
										$elementorsheet_is_enable = 1;
									}
									if ( 'new_spreadsheet_name' === (string) $formkey || 'header_name' === (string) $formkey ) {
											$formvalue                = '';
											$elementorsheet_is_enable = 1;
									}
								}
							);
							if ( $elementorsheet_is_enable ) {
										$wpsse_json_value = wp_slash( wp_json_encode( $globalformdata ) );
										update_metadata( 'post', $value, 'elementorsheets_sheetid', $wpsse_spreadsheetid );
										update_metadata( 'post', $value, '_elementor_data', $wpsse_json_value );
							}
						}
					}
				}
			}
		);

		if ( 'yes' === (string) $existincurrentpage ) {

			$wpsse_json_value = wp_slash( wp_json_encode( $wpsse_data11 ) );

			update_post_meta( $wpsse_post_id, '_elementor_data', $wpsse_json_value );
		}
	}

	/**
	 * Action fire after update.
	 *
	 * @param int   $template_id Template ID.
	 * @param array $template_data Template Data.
	 */
	public static function wpsse_after_update_template( $template_id, $template_data ) {

		$form = get_post_meta( $template_id, '_elementor_template_widget_type' );
		if ( in_array( 'form', $form, true ) ) {
			global $exist;
			$exist = 'no';
			array_walk_recursive(
				$template_data,
				function ( &$value, $key ) {
					if ( 'elementorsheets' === (string) $value ) {
						global $exist;
						$exist = 'yes';
					}
				}
			);

			if ( 'yes' === (string) $exist ) {

				global $spreadsheetid, $globalformdata , $elementorsheet_is_enable;
				$spreadsheetid            = get_post_meta( $template_id, 'elementorsheets_sheetid', true );
				$formdata                 = get_post_meta( $template_id, '_elementor_data' );
				$globalformdata           = json_decode( $formdata[0], true );
				$elementorsheet_is_enable = 0;
				array_walk_recursive(
					$globalformdata,
					function ( &$formvalue, $formkey ) {
						global $spreadsheetid, $elementorsheet_is_enable;
						if ( 'spreadsheetid' === (string) $formkey ) {
							$formvalue                = $spreadsheetid;
							$elementorsheet_is_enable = 1;
						}
					}
				);

				if ( $elementorsheet_is_enable ) {
					$wpsse_json_value = wp_slash( wp_json_encode( $globalformdata ) );
					update_metadata( 'post', $template_id, '_elementor_data', $wpsse_json_value );
				}
			}
		}
	}
	/**
	 * Freeze First Row of the Google Spreadsheet.
	 *
	 * @param string $wpsse_spreadsheetname Spreadsheet ID.
	 * @param string $wpsse_sheetname Sheet Name.
	 * @param int    $wpsse_freeze 1 - Freeze Header, 0 - Unfreeze header.
	 */
	public static function wpsse_freeze_header( $wpsse_spreadsheetname, $wpsse_sheetname, $wpsse_freeze ) {
		$response                  = self::$instance_api->get_sheet_listing( $wpsse_spreadsheetname );
		$wpsse_existingsheetsnames = self::$instance_api->get_sheetid_list( $response );

		$wpsse_is_exist = array_search( $wpsse_sheetname, $wpsse_existingsheetsnames, true );
		if ( $wpsse_is_exist ) {
			$requestbody                    = self::$instance_api->freezeobject( $wpsse_is_exist, $wpsse_freeze );
			$requestobject                  = array();
			$requestobject['spreadsheetid'] = $wpsse_spreadsheetname;
			$requestobject['requestbody']   = $requestbody;
			self::$instance_api->formatsheet( $requestobject );
		}
	}

	/**
	 * Initialize Feed Addon.
	 */
	public static function wpsse_init() {
		// Here its safe to include our action class file.
		include_once dirname( __FILE__ ) . '/class-wpsse-form-sheets-action.php';
		// Instantiate the action class.
		$wpsse_action = new WPSSE_Form_Sheets_Action();
		// Register the action with form widget.
		\ElementorPro\Plugin::instance()->modules_manager->get_modules( 'forms' )->add_form_action( $wpsse_action->get_name(), $wpsse_action );
	}

	/**
	 * Load JS and CSS File.
	 */
	public static function wpsse_load_wp_admin_style() {
		// phpcs:ignore
		if ( isset( $_GET['page'] ) && ( 'elementorsheets' === (string) sanitize_text_field( $_GET['page'] ) || 'wpsyncsheets-for-elementor' === (string) sanitize_text_field( $_GET['page'] ) ) ) {

			wp_register_style( 'wpsse-wp-admin-style', plugin_dir_url( dirname( __FILE__ ) ) . 'assets/css/wpsse-admin-style.css', false, WPSSE_VERSION );
			wp_enqueue_style( 'wpsse-wp-admin-style' );
			wp_register_script( 'wpsse-wp-admin-script', plugin_dir_url( dirname( __FILE__ ) ) . 'assets/js/wpsse-admin-script.js', false, WPSSE_VERSION, true );
			wp_localize_script(
				'wpsse-wp-admin-script',
				'admin_ajax_object',
				array(
					'ajaxurl'          => admin_url( 'admin-ajax.php' ),
					'sync_nonce_token' => wp_create_nonce( 'sync_nonce' ),
				)
			);
			wp_enqueue_script( 'wpsse-wp-admin-script' );
		}
		// phpcs:ignore
		if ( isset( $_GET['action'] ) && 'elementor' === (string) sanitize_text_field( wp_unslash( $_GET['action'] ) ) ) {

			wp_register_script( 'wpsse-wp-admin-script', plugin_dir_url( dirname( __FILE__ ) ) . 'assets/js/wpsse-ui.js', false, WPSSE_VERSION, true );
			wp_enqueue_script( 'wpsse-wp-admin-script' );

			wp_register_script( 'wpsse-wp-customadmin', plugin_dir_url( dirname( __FILE__ ) ) . 'assets/js/wpsse-custom-elementor.js', false, WPSSE_VERSION, true );
			wp_localize_script(
				'wpsse-wp-customadmin',
				'customadmin_ajax_object',
				array(
					'ajaxurl'          => admin_url( 'admin-ajax.php' ),
					'sync_nonce_token' => wp_create_nonce( 'sync_nonce' ),
				)
			);
			wp_enqueue_script( 'wpsse-wp-customadmin' );
			wp_register_style( 'wpsse-wp-admin-uistyle', plugin_dir_url( dirname( __FILE__ ) ) . 'assets/css/wpsse-ui.css', false, WPSSE_VERSION );
			wp_enqueue_style( 'wpsse-wp-admin-uistyle' );
			wp_register_style( 'wpsse-wp-admin-style', plugin_dir_url( dirname( __FILE__ ) ) . 'assets/css/wpsse-admin-style.css', false, WPSSE_VERSION );
			wp_enqueue_style( 'wpsse-wp-admin-style' );
		}
	}

	/**
	 * Enqueue css and js files
	 */
	public static function wpsse_selectively_enqueue_admin_script() {
		wp_enqueue_script( 'wpsse-general-script', WPSSE_URL . 'assets/js/wpsse-general.js', WPSSE_VERSION, true, false );
	}

	/**
	 * Show row meta on the plugin screen.
	 *
	 * @param  mixed $wpsse_links Plugin Row Meta.
	 * @param  mixed $wpsse_file  Plugin Base file.
	 * @return array
	 */
	public static function wpsse_plugin_row_meta( $wpsse_links, $wpsse_file ) {
		if ( 'wpsyncsheets-for-elementor/wpsyncsheets-for-elementor.php' === (string) $wpsse_file ) {

			$wpsse_row_meta = array(
				'docs' => '<a href="' . esc_url( WPSSE_DOCUMENTATION_URL ) . '" title="' . esc_attr( __( 'View Documentation', 'wpsse' ) ) . '" target="_blank">' . esc_html__( 'View Documentation', 'wpsse' ) . '</a>',
			);
			return array_merge( $wpsse_links, $wpsse_row_meta );
		}
		return (array) $wpsse_links;
	}

	/**
	 * Register a plugin menu page.
	 */
	public static function wpsse_menu_page() {
		global $admin_page_hooks, $_parent_pages;
		if ( ! isset( $admin_page_hooks['wpsyncsheets'] ) ) {
			$wpssg_page = add_menu_page(
				esc_attr__( 'WPSyncSheets', 'wpssg' ),
				'WPSyncSheets',
				'manage_options',
				'wpsyncsheets',
				'',
				WPSSE_URL . 'assets/images/menu-icon.svg',
				90
			);
		}
		add_submenu_page( 'wpsyncsheets', 'Google Sheets API Settings', 'Google Sheets API Settings', 'manage_options', 'wpsyncsheets', __CLASS__ . '::wpsse_elementor_sheets_plugin_page' );
		add_submenu_page( 'wpsyncsheets', 'WPSyncSheets For Elementor', 'For Elementor', 'manage_options', 'wpsyncsheets-for-elementor', __CLASS__ . '::wpsse_elementor_sheets_plugin_page', 1 );
		if ( ! isset( $_parent_pages['documentation'] ) ) {
			add_submenu_page( 'wpsyncsheets', 'Documentation', '<div class="wpsse-support">Documentation</div>', 'manage_options', 'documentation', __CLASS__ . '::wppse_handle_external_redirects', 20 );
		}
		if ( ! isset( $_parent_pages['support'] ) ) {
			add_submenu_page( 'wpsyncsheets', 'Support', '<div class="wpsse-support">Support</div>', 'manage_options', 'support', __CLASS__ . '::wppse_handle_external_redirects', 20 );
		}
		self::remove_duplicate_submenu_page();

	}

	/**
	 * License Key admin notice.
	 */
	public static function wpsse_license_notice() {
		$enable = self::$instance->wpsse_check_license_key();
		if ( ! $enable ) {
			echo '
			<div class="notice notice-info">
				<p><strong>' . esc_html__( 'Welcome to WPSyncSheets', 'wpsse' ) . '</strong></p>
				<p>' . esc_html__( 'Please', 'wpsse' ) . ' <a href="' . esc_url( 'admin.php?page=' . self::$wpsse_license_page ) . '">' . esc_html__( 'register', 'wpsse' ) . '</a> ' . esc_html__( 'this version of plugin to get an access for auto updates.', 'wpsse' ) . '</p>
				<p><strong>' . esc_html__( 'Important!', 'wpsse' ) . '</strong> ' . esc_html__( 'One', 'wpsse' ) . ' <a target="_blank" href="https://codecanyon.net/licenses/standard">' . esc_html__( 'standard license', 'wpsse' ) . '</a> ' . esc_html__( 'is valid only for', 'wpsse' ) . ' <strong>' . esc_html__( '1 website', 'wpsse' ) . '</strong>. ' . esc_html__( 'Running multiple websites on a single license is a copyright violation.', 'wpsse' ) . '</p>
			</div>
			';
		}
	}

	/**
	 * Documentation and Support Page Link.
	 *
	 * Redirect the documentation and support page.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function wppse_handle_external_redirects() {
		// phpcs:ignore
		if ( empty( $_GET['page'] ) ) {
			return;
		}

		// phpcs:ignore
		if ( 'documentation' === $_GET['page'] ) {
			// phpcs:ignore
			wp_redirect( WPSSE_DOC_MENU_URL );
			die;
		}

		// phpcs:ignore
		if ( 'support' === $_GET['page'] ) {
			// phpcs:ignore
			wp_redirect( WPSSE_SUPPORT_MENU_URL );
			die;
		}
	}

	/**
	 * Remove duplicate submenu
	 * Submenu page hack: Remove the duplicate WPSyncSheets Plugin link on subpages
	 */
	public static function remove_duplicate_submenu_page() {
		remove_submenu_page( 'wpsyncsheets', 'wpsyncsheets' );
	}

	/**
	 * Plugin Page.
	 */
	public static function wpsse_elementor_sheets_plugin_page() {
		$enable = self::$instance->wpsse_check_license_key();
		if ( ! $enable || ( isset( $_GET['tab'] ) && ! $enable && 'em-settings' !== (string) sanitize_text_field( wp_unslash( $_GET['tab'] ) ) ) ) {
			$_GET['tab'] = 'em-settings';
		}
		if ( isset( $_GET['tab'] ) && 'em-settings' === (string) sanitize_text_field( wp_unslash( $_GET['tab'] ) ) ) {
			if ( isset( $_POST['submit'] ) ) {
				$wpsse_license = isset( $_POST['wpsse_license_key'] ) ? sanitize_text_field( wp_unslash( $_POST['wpsse_license_key'] ) ) : '';
				self::$instance_api->wpsse_update_option( 'wpsse_license_key', $wpsse_license );
			}
			if ( isset( $_POST['wpsse_license_activate'] ) ) {
				// phpcs:ignore
				self::wpsse_activate_license( $_POST );
			}
			if ( isset( $_POST['wpsse_license_deactivate'] ) ) {
				self::wpsse_deactivate_license();
			}
		} else {
			if ( isset( $_POST['submit'] ) ) {
				if ( ! isset( $_POST['wpsse_api_settings'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['wpsse_api_settings'] ) ), 'save_api_settings' ) ) {
					$wpsse_error = '<strong class="err-msg">' . esc_html__( 'Error: Sorry, your nonce did not verify.', 'wpsse' ) . '</strong>';
				} else {
					if ( isset( $_POST['client_token'] ) ) {
						$wpsse_clienttoken = sanitize_text_field( wp_unslash( $_POST['client_token'] ) );
					} else {
						$wpsse_clienttoken = '';
					}
					if ( isset( $_POST['client_id'] ) && isset( $_POST['client_secret'] ) ) {
						$wpsse_google_settings = array( sanitize_text_field( wp_unslash( $_POST['client_id'] ) ), sanitize_text_field( wp_unslash( $_POST['client_secret'] ) ), $wpsse_clienttoken );
					} else {
						$wpsse_google_settings_value = self::$instance_api->wpsse_option( 'wpsse_google_settings' );
						$wpsse_google_settings       = array( $wpsse_google_settings_value[0], $wpsse_google_settings_value[1], $wpsse_clienttoken );
					}
					self::$instance_api->wpsse_update_option( 'wpsse_google_settings', $wpsse_google_settings );
				}
			}
			if ( isset( $_POST['revoke'] ) ) {
				if ( ! isset( $_POST['wpsse_api_settings'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['wpsse_api_settings'] ) ), 'save_api_settings' ) ) {
					$wpsse_error = '<strong class="err-msg">' . esc_html__( 'Error: Sorry, your nonce did not verify.', 'wpsse' ) . '</strong>';
				} else {
					$wpsse_google_settings    = self::$instance_api->wpsse_option( 'wpsse_google_settings' );
					$wpsse_google_settings[2] = '';
					self::$instance_api->wpsse_update_option( 'wpsse_google_settings', $wpsse_google_settings );
					self::$instance_api->wpsse_update_option( 'wpsse_google_accessToken', '' );
				}
			}
		}
		$wpsse_google_settings = self::$instance_api->wpsse_option( 'wpsse_google_settings' );

		if ( ! empty( $wpsse_google_settings[2] ) ) {

			if ( ! self::$instance_api->checkcredenatials() ) {
				$wpsse_error = self::$instance_api->getClient( 1 );
				if ( 'Invalid token format' === (string) $wpsse_error || 'invalid_grant' === (string) $wpsse_error ) {
					$wpsse_error = '<div class="error token_error"><p><strong class="err-msg"> ' . esc_html__( 'Error: Invalid Token - Revoke Token with below settings and try again.', 'wpsse' ) . '</strong></p></div>';
				} else {
					$wpsse_error = '<div class="error token_error"><p><strong class="err-msg">Error: ' . $wpsse_error . '</strong></p></div>';
				}
			}
		}
		$disbledbtn = '';
		$enable     = self::$instance->wpsse_check_license_key();
		if ( ! $enable ) {
			$disbledbtn = 'disabled';
		}
		?>	
		<div class="wpsse-sheetsheaders">
			<div class="wpsse-logo-section">
				<img src="<?php echo esc_url( WPSSE_URL . 'assets/images/wpsse-logo.png' ); ?>">
				<sup>V<?php echo esc_html( WPSSE_VERSION ); ?></sup>
				<div class="duc-btn1">
					<a target="_blank" href="<?php echo esc_url( WPSSE_SUPPORT_URL ); ?>"><?php echo esc_html__( 'Submit A Ticket', 'wpsse' ); ?></a> 
				</div>
				<div class="duc-btn">
					<a target="_blank" href="<?php echo esc_url( WPSSE_DOCUMENTATION_URL ); ?>"><?php echo esc_html__( 'Documentation', 'wpsse' ); ?></a>     
				</div>
			</div>
			<div class="tab">
				<button class="tablinks googleapi-settings" onclick="wpsseTab(event, 'googleapi-settings')"
				<?php
				if ( ! empty( $disbledbtn ) ) {
					echo 'disabled="disabled"';
				}
				?>
				>
					<span class="tab-icon"></span><?php echo esc_html__( 'Google API', 'wpsse' ); ?> <br><?php echo esc_html__( 'Settings', 'wpsse' ); ?>
				</button>
				<button class="tablinks em-settings" onclick="wpsseTab(event, 'em-settings')"><span class="tab-icon"></span><?php echo esc_html__( 'License', 'wpsse' ); ?></button>
			</div>
			<div id="googleapi-settings" class="tabcontent">
				<h3><?php echo esc_html__( 'Google API Settings', 'wpsse' ); ?></h3>
				<p><?php echo esc_html__( 'Create new google APIs with Client ID and Client Secret keys to get an access for the google drive and google sheets. Please follow the documentation, login to your Gmail Account and start with', 'wpsse' ); ?> <a href="<?php echo esc_url( WPSSE_DOC_SHEET_SETTING_URL ); ?>" target="_blank"><?php echo esc_html__( 'here.', 'wpsse' ); ?></a></p>
				<form method="post" action="<?php echo esc_html( admin_url( 'admin.php?page=wpsyncsheets-for-elementor' ) ); ?>">
					<?php wp_nonce_field( 'save_api_settings', 'wpsse_api_settings' ); ?>
		<?php
		$google_settings_value = self::$instance_api->wpsse_option( 'wpsse_google_settings' );
		?>
					<div id="universal-message-container woocommerce">
						<br>
						<div class="options">
		<?php
		if ( ! empty( $wpsse_error ) ) {
			$allowed_html = wp_kses_allowed_html( 'post' );
			echo wp_kses( $wpsse_error, $allowed_html );
		}
		?>
		<?php
		if ( isset( $google_settings_value[0] ) ) {
			$client_id = $google_settings_value[0];
		} else {
			$client_id = '';
		}
		if ( isset( $google_settings_value[1] ) ) {
			$client_secret = $google_settings_value[1];
		} else {
			$client_secret = '';
		}
		?>
							<table class="form-table">
								<tr>
									<th> <?php echo esc_html__( 'Client Id', 'wpsse' ); ?> </th>
									<td class="forminp forminp-text">
										<input type="text" name="client_id" value="<?php echo esc_attr( $client_id ); ?>" size="80" class = "googlesettinginput" placeholder="<?php echo esc_html__( 'Enter Client Id', 'wpsse' ); ?>" 
										<?php
										if ( ! empty( $google_settings_value[0] ) ) {
											echo 'readonly';
										}
										?>
	/>
									</td>
								</tr>
								<tr>
									<th><?php echo esc_html__( 'Client Secret', 'wpsse' ); ?> </th>
									<td class="forminp forminp-text">
										<input type="text" name="client_secret" value="<?php echo esc_attr( $client_secret ); ?>" size="80" class = "googlesettinginput" placeholder="<?php echo esc_html__( 'Enter Client Secret', 'wpsse' ); ?>" 
			<?php
			if ( ! empty( $google_settings_value[1] ) ) {
				echo 'readonly';
			}
			?>
	/>
									</td>
								</tr>
		<?php
		if ( ! empty( $google_settings_value[0] ) && ! empty( $google_settings_value[1] ) ) {
			$token_value = $google_settings_value[2];
			?>
									<tr>
										<th><?php echo esc_html__( 'Client Token', 'wpsse' ); ?></th>
				<?php
				// phpcs:ignore
				if ( empty( $token_value ) && ! isset( $_GET['code'] ) ) {
					$auth_url = self::$instance_api->getClient();
					?>
											<td id="authbtn">
												<a href="<?php echo esc_url( $auth_url ); ?>" target="_blank" id="authlink"><div class="wpsse-button wpsse-button-secondary"><?php echo esc_html__( 'Click here to generate an Authentication Token', 'wpsse' ); ?></div></a>
											</td>
					<?php
				}
				$wpsse_code = '';
				// phpcs:ignore
				if ( isset( $_GET['code'] ) && ! empty( sanitize_text_field( wp_unslash( $_GET['code'] ) ) ) ) {
					// phpcs:ignore
					$wpsse_code = sanitize_text_field( wp_unslash( $_GET['code'] ) );
				}
				?>
										<td id="authtext" 
				<?php
				if ( ! empty( $token_value ) || $wpsse_code ) {
					?>
											class="wpsse-authtext forminp forminp-text" 
					<?php
				} else {
					?>
class="forminp forminp-text"<?php } ?>><input type="text" name="client_token" value="<?php echo $token_value ? esc_attr( $token_value ) : esc_attr( $wpsse_code ); ?>" size="80" placeholder="<?php echo esc_html__( 'Please enter authentication code', 'wpsse' ); ?>" id="client_token" class="googlesettinginput" 
																			<?php
																			if ( ! empty( $google_settings_value[2] ) ) {
																				echo 'readonly';
																			}
																			?>
				/>
									</td>
									</tr>
			<?php }if ( ! empty( $token_value ) ) { ?>
									<tr>
										<td></td>
										<td><input type="submit" name="revoke" id="revoke" value = "<?php echo esc_attr__( 'Revoke Token', 'wpsse' ); ?>" class="wpsse-button wpsse-button-secondary"/></td>
									</tr>
			<?php } ?>    
							</table>
						</div>
		<?php
		if ( isset( $_SERVER['SERVER_NAME'] ) ) {
			$site_url = sanitize_text_field( wp_unslash( $_SERVER['SERVER_NAME'] ) );
			$site_url = str_replace( 'www.', '', $site_url );
		}
		?>
						<p class="submit">
							<input type="submit" name="submit" id="submit" class="wpsse-button wpsse-button-primary" value="<?php echo esc_attr__( 'Save', 'wpsse' ); ?>">
		<?php
		if ( ! empty( $token_value ) || ! empty( $google_settings_value[0] ) || ! empty( $google_settings_value[1] ) ) {
			?>
								<input type="submit" name="reset_settings" id="reset_settings" value = "<?php echo esc_attr__( 'Reset Settings', 'wpsse' ); ?>" class="wpsse-button wpsse-button-primary reset_settings"/>
			<?php } ?>
						</p>
						<table class="copy-url-table" cellpadding="0" cellspacing="0" width="100%" border="0px">
							<tr>
								<td><?php echo esc_html__( 'Authorized Domain : ', 'wpsse' ); ?></td>
								<td><span id="authorized_domain"><?php echo esc_html( $site_url ); ?></span><span class="copy-icon wpsse-button wpsse-button-primary" id="a_domain" onclick="wpsseCopy('authorized_domain','a_domain');"></span></td>
							</tr>
							<tr>
								<td><?php echo esc_html__( 'Authorised redirect URIs : ', 'wpsse' ); ?></td>
								<td><span id="authorized_uri"><?php echo esc_html( admin_url( 'admin.php?page=wpsyncsheets-for-elementor' ) ); ?></span><span class="copy-icon wpsse-button wpsse-button-primary" onclick="wpsseCopy('authorized_uri','a_uri');" id="a_uri"></span></td>
							</tr>
						</table>
					</div>
				</form>
			</div>            
			<div id="em-settings" class="tabcontent">
				<h3><?php echo esc_html__( 'License', 'wpsse' ); ?></h3>
				<?php
				$wpsse_license = self::$instance_api->wpsse_option( 'wpsse_license_key' );
				$wpsse_status  = self::$instance_api->wpsse_option( 'wpsse_license_status' );
				?>
				<p class="f16"><strong><?php echo esc_html__( 'Where can I find my purchase code?', 'wpsse' ); ?></strong></p>
				<ol>
					<li><?php echo esc_html__( 'Please go to', 'wpsse' ); ?> <a target="_blank" href="https://codecanyon.net/downloads"><?php echo esc_html( 'Codecanyon.net/downloads' ); ?></a></li>
					<li><?php echo esc_html__( 'Click the', 'wpsse' ); ?> <strong><?php echo esc_html__( 'Download', 'wpsse' ); ?></strong> <?php echo esc_html__( 'button in WPSyncSheets For Elementor row.', 'wpsse' ); ?></li>
					<li><?php echo esc_html__( 'Select', 'wpsse' ); ?> <strong><?php echo esc_html__( 'License Certificate &amp; Purchase code.', 'wpsse' ); ?></strong></li>
					<li><?php echo esc_html__( 'Copy', 'wpsse' ); ?> <strong><?php echo esc_html__( 'Item Purchase Code', 'wpsse' ); ?></strong></li>
					<li><?php echo esc_html__( 'Please go to', 'wpsse' ); ?> <a target="_blank" href="<?php echo esc_url( self::$wpsse_register_link ); ?>"><?php echo esc_html__( 'WPSyncSheets Envato User Registration', 'wpsse' ); ?></a> <?php echo esc_html__( 'and register with item purchase code.', 'wpsse' ); ?></li>
					<li><?php echo esc_html__( 'After registration process click on View Licenses.', 'wpsse' ); ?></li>
					<li><?php echo esc_html__( 'Click on key icon', 'wpsse' ); ?> <span class="dashicons dashicons-admin-network"></span> <?php echo esc_html__( 'to copy license key &amp; paste below license key field.', 'wpsse' ); ?></li>
				</ol>
				<div class="data-collection">

						<p class="f16"><strong><?php echo esc_html__( 'Data collection', 'wpsse' ); ?></strong></p>
						<p><?php echo esc_html__( 'WPSyncSheets does not collect any personal data. However, we gather some basic information about your website to validate your license and product registration. These are:', 'wpsse' ); ?></p>

						<ol>
							<li><?php echo esc_html__( 'The purchase code that was used for product registration.', 'wpsse' ); ?></li>
							<li><?php echo esc_html__( 'The domain name that plugin uses.', 'wpsse' ); ?></li>
						</ol>

						<p><?php echo esc_html__( 'In order to serve and check for updates, from time to time, your WordPress installation establishes an anonymous connection to our servers.', 'wpsse' ); ?></p>

					</div>
				<div>
					<form method="post" action="<?php echo esc_html( admin_url( 'admin.php?page=wpsyncsheets-for-elementor&tab=em-settings' ) ); ?>">
						<?php
						if ( isset( $_GET['sl_activation'] ) && ! empty( $_GET['message'] ) ) {
							switch ( $_GET['sl_activation'] ) {
								case 'false':
									$message = urldecode( sanitize_text_field( wp_unslash( $_GET['message'] ) ) );
									?>
										<div class="error">
											<p><?php echo esc_html( $message ); ?></p>
										</div>
										<?php
									break;
								case 'true':
								default:
									break;
							}
						}
						?>
						<table class="form-table license_table">
							<tbody>
								<tr valign="top">
									<th scope="row" valign="top">
										<?php echo esc_html__( 'License Key', 'wpsse' ); ?>
									</th>
									<td>
										<?php
										$readonly = false;
										if ( false !== $wpsse_status && 'valid' === (string) $wpsse_status ) {
											$readonly = true;
										}
										?>
										<input id="wpsse_license_key" name="wpsse_license_key" type="text" class="regular-text" value="<?php echo esc_attr( $wpsse_license ); ?>" placeholder="<?php echo esc_html__( 'Enter your license key', 'wpsse' ); ?>"
										<?php
										if ( $readonly ) {
											echo 'readonly';
										}
										?>
										/>
										<label class="description" for="wpsse_license_key"></label>
										<a href="<?php echo esc_url( self::$wpsse_register_link ); ?>" target="_blank" class="wpsse-register-link"><?php echo esc_html__( 'Click to generate license key', 'wpsse' ); ?></a>
									</td>
								</tr>
					<?php if ( ! empty( $wpsse_license ) ) { ?>
						<tr valign="top">
							<th scope="row" valign="top">
								<?php echo esc_html__( 'Activate License', 'wpsse' ); ?>
							</th>
							<td>
								<?php if ( false !== $wpsse_status && 'valid' === (string) $wpsse_status ) { ?>
									<span class="wpsse-license-status"><?php echo esc_html__( 'active', 'wpsse' ); ?></span>
									<?php wp_nonce_field( 'wpsse_edd_nonce', 'wpsse_edd_nonce' ); ?>
									<input type="submit" class="wpsse-button" name="wpsse_license_deactivate" value="<?php echo esc_html__( 'Deactivate License', 'wpsse' ); ?>"/>
									<?php
								} else {
									wp_nonce_field( 'wpsse_edd_nonce', 'wpsse_edd_nonce' );
									?>
									<input type="submit" class="wpsse-button" name="wpsse_license_activate" value="<?php echo esc_html__( 'Activate License', 'wpsse' ); ?>"/>
								<?php } ?>
							</td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
			<input type="submit" name="submit"  class="wpsse-button wpsse-button-primary" value="Save">
		</form>
		<p class="box">
			<strong><?php echo esc_html__( 'Important!', 'wpsse' ); ?></strong> <?php echo esc_html__( 'One', 'wpsse' ); ?> <a target="_blank" href="https://codecanyon.net/licenses/standard"><?php echo esc_html__( 'standard license', 'wpsse' ); ?></a> <?php echo esc_html__( 'is valid only for', 'wpsse' ); ?> <strong><?php echo esc_html__( '1 website', 'wpsse' ); ?></strong>. <?php echo esc_html__( 'Running multiple websites on a single license is a copyright violation.', 'wpsse' ); ?><br>
			<?php echo esc_html__( 'When moving a site from one domain to another please deregister the plugin first.', 'wpsse' ); ?>
		</p>
			</div>  
		</div>  		 
		</div>
		<?php
	}

	/**
	 * Prepare Google Spreadsheet list.
	 *
	 * @return array $sheetarray Spreadsheet List.
	 */
	public static function wpsse_list_googlespreedsheet() {
		/* Build choices array. */
		$sheetarray = array(
			'' => esc_html__( 'Select Google Spreeadsheet', 'wpsse' ),
		);

		$sheetarray = self::$instance_api->get_spreadsheet_listing( $sheetarray );
		return $sheetarray;
	}

	/**
	 * Check posted data before processing.
	 *
	 * @param array $wpsse_data Posted Elementor Data.
	 */
	public static function wpsse_ajax_register_action( $wpsse_data ) {

		$wpsse_exclude_headertype = array( 'honeypot', 'recaptcha', 'recaptcha_v3', 'html' );
		//phpcs:ignore
		if ( ! isset( $_REQUEST['actions'] ) ) {
			return;
		}
		//phpcs:ignore
		$wpsse_data = json_decode( sanitize_text_field( wp_unslash( $_REQUEST['actions'] ) ), true );

		if ( isset( $wpsse_data['save_builder'] ) ) {
			$wpsse_google_settings = self::$instance_api->wpsse_option( 'wpsse_google_settings' );

			if ( ! empty( $wpsse_google_settings ) ) {

				$wpsse_data = Plugin::elementor()->db->iterate_data(
					$wpsse_data,
					function ( $wpsse_element ) use ( &$do_update ) {

						if ( isset( $wpsse_element['widgetType'] ) && 'form' === (string) $wpsse_element['widgetType'] ) {

							global $wpsse_header_list, $wpsse_exclude_headertype, $wpsse_spreadsheetid,$wpsse_sheetname;
							if ( isset( $wpsse_element['settings']['submit_actions'] ) && in_array( 'elementorsheets', $wpsse_element['settings']['submit_actions'], true ) ) {

								$wpsse_header_list   = array();
								$wpsse_spreadsheetid = isset( $wpsse_element['settings']['spreadsheetid'] ) ? $wpsse_element['settings']['spreadsheetid'] : '';
								$wpsse_sheetname     = isset( $wpsse_element['settings']['sheet_name'] ) ? $wpsse_element['settings']['sheet_name'] : '';
								$wpsse_sheetheaders  = array_column( $wpsse_element['settings']['elementorsheets_fields_map'], 'local_id' );

								if ( empty( $wpsse_spreadsheetid ) ) {
									$es_error = new WP_Error( esc_html__( '- Please select spreadsheet : WPSyncSheets', 'wpsse' ), '', '' );
									wp_send_json_error( $es_error );
								}

								if ( 'new' === (string) $wpsse_spreadsheetid && ! isset( $wpsse_element['settings']['new_spreadsheet_name'] ) ) {

									$es_error = new WP_Error( esc_html__( '- Please enter spreadsheet name : WPSyncSheets', 'wpsse' ), '', '' );
									wp_send_json_error( $es_error );
								}

								if ( empty( $wpsse_sheetname ) ) {
									$es_error = new WP_Error( esc_html__( '- Please enter sheet name : WPSyncSheets', 'wpsse' ), '', '' );
									wp_send_json_error( $es_error );
								}
								if ( empty( $wpsse_sheetheaders ) && isset( $wpsse_sheetheaders ) && ! is_array( $wpsse_sheetheaders ) ) {
										$es_error = new WP_Error( esc_html__( '- Please select sheet headers : WPSyncSheets', 'wpsse' ), '', '' );
										wp_send_json_error( $es_error );
								}

								$wpsse_header_list = array_column( $wpsse_element['settings']['elementorsheets_fields_map'], 'remote_label' );

								if ( 'new' !== $wpsse_spreadsheetid ) {
									$response                  = self::$instance_api->get_sheet_listing( $wpsse_spreadsheetid );
									$wpsse_existingsheetsnames = self::$instance_api->get_sheetid_list( $response );
									if ( in_array( $wpsse_sheetname, $wpsse_existingsheetsnames, true ) ) {
										$wpsse_range     = trim( $wpsse_sheetname ) . '!A1:ZZ1';
										$wpsse_response  = self::$instance_api->get_row_list( $wpsse_spreadsheetid, $wpsse_range );
										$wpsse_data      = $wpsse_response->getValues();
										$existingheaders = $wpsse_data[0];
										$is_mismatch     = 0;

										$counter = 0;
										$headers = array();
										foreach ( $existingheaders as $header ) {
											if ( 'Submission Date' === (string) $header || 'Page Referer Url' === (string) $header ) {
												break;
											}
											$headers[] = $header;
										}
										$headers         = array_filter( $headers );
										$existingheaders = array_filter( $existingheaders );
										if ( count( $headers ) > count( $wpsse_header_list ) ) {
											$counter = count( $headers );
										} else {
											$counter = count( $wpsse_header_list );
										}
										for ( $i = 0; $i < $counter; $i++ ) {
											if ( isset( $existingheaders[ $i ] ) ) {
												if ( (string) strtolower( $wpsse_header_list[ $i ] ) !== (string) strtolower( $existingheaders[ $i ] ) ) {
													$is_mismatch = 1;
												}
											} else {
												$is_mismatch = 1;
											}
										}

										if ( $is_mismatch ) {
																		$es_error = new WP_Error( esc_html__( '- Sheet Headers are not match with spreadsheet, please choose create new spreadsheet option or change sheet name. : WPSyncSheets', 'wpsse' ), '', '' );
																		wp_send_json_error( $es_error );
										}
									}
								}
							}
						}
					}
				);
			}
		}
	}

	/**
	 * Update old meta key, new meta key array.
	 */
	public static function wpsse_old_option_keys() {
		return array(
			'wpsse_google_accessToken' => 'elementorsheets_google_accessToken',
			'wpsse_google_settings'    => 'elementorsheets_google_settings',
		);
	}

	/**
	 * Update old meta key to new meta key
	 */
	public static function wpsse_database_update() {
		$wpsse_is_updated = self::$instance_api->wpsse_option( 'wpsse_database_updated' );
		$wpsse_old_keys   = self::$instance->wpsse_old_option_keys();
		global $wpdb;
		if ( ! $wpsse_is_updated ) {
			$table_name = $wpdb->prefix . 'options';
			foreach ( $wpsse_old_keys as $newkey => $oldkey ) {
				// @codingStandardsIgnoreStart
				$sql    = $wpdb->prepare( "UPDATE `$table_name` SET `option_name`=%s WHERE `option_name`=%s", $newkey, $oldkey );
				$result = $wpdb->get_results( $sql );
				// @codingStandardsIgnoreEnd
			}
			self::$instance_api->wpsse_update_option( 'wpsse_database_updated', 1 );
		}
	}

	/**
	 * Reset Google API Settings
	 */
	public static function wpsse_reset_settings() {
		try {
			$wpsse_google_settings = self::$instance_api->wpsse_option( 'wpsse_google_settings' );
			$settings              = array();
			foreach ( $wpsse_google_settings as $key => $value ) {
				$settings[ $key ] = '';
			}
			self::$instance_api->wpsse_update_option( 'wpsse_google_settings', $settings );
			self::$instance_api->wpsse_update_option( 'wpsse_google_accessToken', '' );
		} catch ( Exception $e ) {
			return $e->getMessage(); }
		echo 'successful';
		wp_die();
	}
	/**
	 * Change the row format of spreadsheet.
	 */
	public static function get_row_format() {
		$params = array( 'valueInputOption' => 'RAW' );
		return $params;
	}

	/**
	 * Prepare Data
	 *
	 * @param array $wpsse_data Elementor Data.
	 */
	public static function wpsse_prepare_data( $wpsse_data = array() ) {
		global $wpsse_spreadsheetid, $wpsse_sheetname, $wpsse_headers, $lead_created_date, $lead_created_page_url;
		array_walk_recursive(
			$wpsse_data,
			function ( $value, $key ) {
				global $wpsse_spreadsheetid, $wpsse_sheetname, $wpsse_headers, $lead_created_date, $lead_created_page_url;

				if ( 'spreadsheetid' === (string) $key ) {
					$wpsse_spreadsheetid = $value;
				}
				if ( 'local_id' === (string) $key ) {
					$wpsse_headers[] = $value;
				}
				if ( 'lead_created_date' === (string) $key ) {
					$lead_created_date = $value;
				}
				if ( 'lead_created_page_url' === (string) $key ) {
					$lead_created_page_url = $value;
				}
				if ( 'sheet_name' === (string) $key ) {
					$wpsse_sheetname = $value;
				}
				if ( 'templateID' === (string) $key ) {

					$form = get_post_meta( $value, '_elementor_template_widget_type' );

					if ( in_array( 'form', $form, true ) ) {
						global $globalformdata;
						global $wpsse_spreadsheetid, $wpsse_sheetname, $wpsse_headers, $lead_created_date, $lead_created_page_url;
						$formdata       = get_post_meta( $value, '_elementor_data' );
						$globalformdata = json_decode( $formdata[0], true );
						array_walk_recursive(
							$globalformdata,
							function ( $formvalue, $formkey ) {
								global $wpsse_spreadsheetid, $wpsse_sheetname, $wpsse_headers, $lead_created_date, $lead_created_page_url;
								if ( 'spreadsheetid' === (string) $formkey ) {
									$wpsse_spreadsheetid = $formvalue;
								}
								if ( 'local_id' === (string) $formkey ) {
									$wpsse_headers[] = $formvalue;
								}
								if ( 'lead_created_date' === (string) $formkey ) {
										$wpsse_headers[]   = $formvalue;
										$lead_created_date = $formvalue;
								}
								if ( 'lead_created_page_url' === (string) $formkey ) {
										$wpsse_headers[]       = $formvalue;
										$lead_created_page_url = $formvalue;
								}
								if ( 'sheet_name' === (string) $formkey ) {
									$wpsse_sheetname = $formvalue;
								}
							}
						);
					}
				}
			}
		);

		$wpsse_response                          = array();
		$wpsse_response['wpsse_spreadsheetid']   = $wpsse_spreadsheetid;
		$wpsse_response['wpsse_sheetname']       = $wpsse_sheetname;
		$wpsse_response['wpsse_headers']         = $wpsse_headers;
		$wpsse_response['lead_created_date']     = $lead_created_date;
		$wpsse_response['lead_created_page_url'] = $lead_created_page_url;
		return $wpsse_response;
	}
	/**
	 * Return Date based on timestamp.
	 *
	 * @param int $timestamp Timestamp.
	 */
	public static function wpsse_get_date( $timestamp ) {
		$date_format = apply_filters( 'wpsse_date_format', get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) );
		$wpsse_date  = gmdate( $date_format, $timestamp );
		return $wpsse_date;
	}
	/**
	 * Activate License
	 *
	 * @param array $data .
	 */
	public static function wpsse_activate_license( $data = array() ) {
		// listen for our activate button to be clicked.

		if ( isset( $data['wpsse_license_activate'] ) ) {

			// run a quick security check.
			if ( ! check_admin_referer( 'wpsse_edd_nonce', 'wpsse_edd_nonce' ) ) {
				return; // get out if we didn't click the Activate button.
			}

			// retrieve the license from the database.
			$license = trim( self::$instance_api->wpsse_option( 'wpsse_license_key' ) );

			// data to send in our API request.
			$api_params = array(
				'edd_action' => 'activate_license',
				'license'    => $license,
				'item_name'  => rawurlencode( WPSSE_PLUGIN_NAME ), // the name of our product in EDD.
				'url'        => home_url(),
			);

			// Call the custom API.
			$response = wp_remote_post(
				self::$wpsse_store_url,
				array(
					'timeout'   => 15,
					'sslverify' => false,
					'body'      => $api_params,
				)
			);

			// make sure the response came back okay.
			if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {

				$message = ( is_wp_error( $response ) && ! empty( $response->get_error_message() ) ) ? $response->get_error_message() : __( 'An error occurred, please try again.' );

			} else {

				$license_data = json_decode( wp_remote_retrieve_body( $response ) );

				if ( false === $license_data->success ) {

					switch ( $license_data->error ) {

						case 'expired':
							$message = sprintf(
								/* translators: expiry date. */
								__( 'Your license key expired on %s.' ),
								date_i18n( self::$instance_api->wpsse_option( 'date_format' ), strtotime( $license_data->expires, mktime() ) )
							);
							break;

						case 'revoked':
							$message = __( 'Your license key has been disabled.' );
							break;

						case 'missing':
							$message = __( 'Invalid license.' );
							break;

						case 'invalid':
						case 'site_inactive':
							$message = __( 'Your license is not active for this URL.' );
							break;

						case 'item_name_mismatch':
							/* translators: the plugin name. */
							$message = sprintf( __( 'This appears to be an invalid license key for %s.' ), 'wpsse' );
							break;

						case 'no_activations_left':
							$message = __( 'Your license key has reached its activation limit.' );
							break;

						default:
							$message = __( 'An error occurred, please try again.' );
							break;
					}
				}
			}

			// Check if anything passed on a message constituting a failure.
			if ( ! empty( $message ) ) {
				$base_url = admin_url( 'admin.php?page=' . self::$wpsse_license_page );
				$redirect = add_query_arg(
					array(
						'sl_activation' => 'false',
						'message'       => rawurlencode( $message ),
					),
					$base_url
				);

				wp_safe_redirect( $redirect );
				exit();
			}
			self::$instance_api->wpsse_update_option( 'wpsse_license_status', $license_data->license );
			wp_safe_redirect( admin_url( 'admin.php?page=' . self::$wpsse_license_page ) );
			exit();
		}
	}
	/**
	 * Deactivate License
	 */
	public static function wpsse_deactivate_license() {

		$license = trim( self::$instance_api->wpsse_option( 'wpsse_license_key' ) );
		// run a quick security check.
		if ( ! check_admin_referer( 'wpsse_edd_nonce', 'wpsse_edd_nonce' ) ) {
			return; // get out if we didn't click the Deactivate button.
		}
		// data to send in our API request.
		$api_params = array(
			'edd_action'  => 'deactivate_license',
			'license'     => $license,
			'item_id'     => WPSSE_PLUGIN_ITEM_ID,
			'item_name'   => rawurlencode( WPSSE_PLUGIN_NAME ), // the name of our product in EDD.
			'url'         => home_url(),
			'environment' => function_exists( 'wp_get_environment_type' ) ? wp_get_environment_type() : 'production',
		);

		$response = wp_remote_post(
			self::$wpsse_store_url,
			array(
				'timeout'   => 15,
				'sslverify' => false,
				'body'      => $api_params,
			)
		);

		if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {

			if ( is_wp_error( $response ) ) {
				$message = $response->get_error_message();
			} else {
				$message = __( 'An error occurred, please try again.' );
			}

			$redirect = add_query_arg(
				array(
					'page'          => self::$wpsse_license_page,
					'sl_activation' => 'false',
					'message'       => rawurlencode( $message ),
				),
				admin_url( 'admin.php?page=' )
			);

			wp_safe_redirect( $redirect );
			exit();
		}

		// decode the license data.
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );

		if ( 'deactivated' === $license_data->license ) {
			delete_option( 'wpsse_license_status' );
		}
		wp_safe_redirect( admin_url( 'admin.php?page=' . self::$wpsse_license_page ) );
		exit();
	}

	/**
	 * Check License key.
	 */
	public static function wpsse_check_license_key() {
		$wpsse_license = self::$instance_api->wpsse_option( 'wpsse_license_key' );
		$wpsse_status  = self::$instance_api->wpsse_option( 'wpsse_license_status' );
		// Check for transient. If none, then execute EDD License Check Status.
		$license_key_status = get_transient( 'wpsse_check_license_key_status' );

		if ( false === $license_key_status ) {

			$wpsse_activestatus = self::wpsse_check_license_key_status( $wpsse_license );
			if ( false !== $wpsse_activestatus && 'valid' === (string) $wpsse_activestatus && ! empty( $wpsse_license ) ) {
				// Put the results in a transient. Expire after 14 Days.
				set_transient( 'wpsse_check_license_key_status', $wpsse_activestatus, 60 * 60 * 24 * 14 );
				self::$instance_api->wpsse_update_option( 'wpsse_license_key_transient', 'yes' );
				return true;
			} elseif ( 'valid' !== (string) $wpsse_status && ! empty( $wpsse_status ) ) {
				self::$instance_api->wpsse_update_option( 'wpsse_license_key', '' );
				self::$instance_api->wpsse_update_option( 'wpsse_license_status', '' );
				return false;
			} else {
				return false;
			}
		} else {
			// Depends on transient it will be true.
			return true;
		}
	}
	/**
	 * Check Remoate License key status.
	 *
	 * @param string $wpsse_license license key.
	 */
	public static function wpsse_check_license_key_status( $wpsse_license ) {

		// data to send in our API request.
		$api_params = array(
			'edd_action' => 'check_license',
			'license'    => $wpsse_license,
			'item_id'    => WPSSE_PLUGIN_ITEM_ID,
			'item_name'  => rawurlencode( WPSSE_PLUGIN_NAME ),
			'url'        => home_url(),
		);

		$response = wp_remote_post(
			self::$wpsse_store_url,
			array(
				'timeout'   => 15,
				'sslverify' => false,
				'body'      => $api_params,
			)
		);

		if ( is_wp_error( $response ) ) {
			return false;
		}

		$license_data = json_decode( wp_remote_retrieve_body( $response ) );

		return $license_data->license;
	}
	/**
	 * Get headers from document settings
	 *
	 * @param array $wpsse_data document data.
	 * @return array $wpsse_header_list headers array.
	 */
	public static function wpsse_get_headers( $wpsse_data ) {

		$wpsse_headers = array();
		global $wpsse_header_list;
		$wpsse_header_list = array();
		$wpsse_data        = Plugin::elementor()->db->iterate_data(
			$wpsse_data,
			function ( $wpsse_element ) use ( &$do_update ) {

				if ( isset( $wpsse_element['widgetType'] ) && 'form' === (string) $wpsse_element['widgetType'] ) {

					global $wpsse_header_list, $wpsse_exclude_headertype, $wpsse_spreadsheetid,$wpsse_sheetname;
					if ( isset( $wpsse_element['settings']['submit_actions'] ) && in_array( 'elementorsheets', $wpsse_element['settings']['submit_actions'], true ) ) {

						$wpsse_header_list = array();
						$wpsse_header_list = array_column( $wpsse_element['settings']['elementorsheets_fields_map'], 'remote_label' );

					}
				}
			}
		);

		return $wpsse_header_list;
	}

}
WPSSE_Plugin_Setting::wpsse_initilization();
