<?php
/**
 * WPSSE Dependency Checker.
 *
 * @since 1.0.0
 * @package wpsyncsheets-for-elementor
 */

/**
 * Class WPSSE_Dependencies.
 *
 * @since 1.0.0
 */
class WPSSE_Dependencies {

	/**
	 * Active Plugin Array
	 *
	 * @var $wpsse_active_plugins
	 */
	private static $wpsse_active_plugins;

	/**
	 * Get list of all active plugins.
	 */
	public static function wpsse_dependencies_action_init() {
		self::$wpsse_active_plugins = (array) get_option( 'active_plugins', array() );
	}
	/**
	 * Check Elementor Pro exist
	 *
	 * @return Boolean
	 */
	public static function wpsse_elementor_pro_active_check() {
		if ( ! self::$wpsse_active_plugins ) {
			self::wpsse_dependencies_action_init();
		}
		return in_array( 'elementor-pro/elementor-pro.php', self::$wpsse_active_plugins, true ) || array_key_exists( 'elementor-pro/elementor-pro.php', self::$wpsse_active_plugins );
	}
	/**
	 * Check if Elementor Pro active
	 *
	 * @return Boolean
	 */
	public static function wpsse_is_elementor_pro_active() {
		return self::wpsse_elementor_pro_active_check();
	}
}
