/**
 * Admin Enqueue Script
 *
 * @package     wpsyncsheets-for-elementor
 */

(function($) {
	"use strict";
	$( document ).ready(
		function(){
			$( "#authlink" ).on(
				'click',
				function(e){
					$( '#authbtn' ).hide();
					document.getElementById( "authtext" ).style.display = "inline-block";
				}
			);
			$( "#revoke" ).on(
				'click',
				function(e){
					document.getElementById( "authtext" ).style.display     = "none";
					document.getElementById( "client_token" ).style.display = "none";
				}
			);
			$( '#licence_submit' ).on(
				'click',
				function(e) {
					e.preventDefault();
					$( '.wpsse-license-result' ).html( '' );
					$( '#licence_submit' ).hide();
					$( '#licenceloader' ).show();
					$( '#licencetext' ).show();
					wpsseLicenseCheck( 'activate' );
				}
			);
			$( "#reset_settings" ).on(
				"click",
				function(e){
					e.preventDefault();

					jQuery.ajax(
						{
							url : admin_ajax_object.ajaxurl,
							type : 'post',
							data :"action=wpsse_reset_settings",
							beforeSend:function(){
								if (confirm( "Are you sure you want to reset settings?" )) {

								} else {
									return false;
								}
							},
							success : function( response ) {
								if (String( response ) === 'successful') {
									location.reload();
								} else {
									alert( response );
								}
							},
							error: function (s) {
								alert( 'Error' );
							}
						}
					);
				}
			);
			$( '.wpsse-support' ).parent().attr( 'target','_blank' );
		}
	);

	$( document ).ready(
		function(){
			var activeTab = getParameterByName( 'tab' );
			if ( activeTab != null) {
				var classNm = "button." + activeTab;
				if ( $( classNm ).is( ':disabled' )) {
					var classNm = "button.em-settings";
					wpsseTab( event, 'em-settings' );
				} else {
					wpsseTab( event, activeTab );
				}
				$( classNm ).addClass( 'active' );
			} else {
				var classNm = "button.googleapi-settings";
				if ( $( classNm ).is( ':disabled' )) {
					var classNm = "button.em-settings";
					wpsseTab( event, 'em-settings' );
				}
				$( classNm ).addClass( 'active' );
			}
		}
	);
})( jQuery );
function wpsseTab(evt, tabName) {
	var i, tabContent, tabLinks, tabContentlength, tabLinkslength;
	tabContent       = document.getElementsByClassName( "tabcontent" );
	tabContentlength = tabContent.length;
	for (i = 0; i < tabContentlength; i++) {
		tabContent[i].style.display = "none";
	}
	tabLinks       = document.getElementsByClassName( "tablinks" );
	tabLinkslength = tabLinks.length;
	for (i = 0; i < tabLinkslength; i++) {
		tabLinks[i].className = tabLinks[i].className.replace( " active", "" );
	}
	document.getElementById( tabName ).style.display = "block";
	var type = typeof event;
	if (type !== 'undefined') {
		evt.currentTarget.className += " active";
	}
}
function getParameterByName(name, url) {
	if ( ! url) {
		url = window.location.href;
	}
	name        = name.replace( /[\[\]]/g, '\\$&' );
	var regex   = new RegExp( '[?&]' + name + '(=([^&#]*)|&|#|$)' ),
		results = regex.exec( url );
	if ( ! results) {
		return null;
	}
	if ( ! results[2]) {
		return '';
	}
	return decodeURIComponent( results[2].replace( /\+/g, ' ' ) );
}
function wpsseLicenseCheck( action ) {

	if ( String( jQuery( '#ws_envato' ).val() ) === '' ) {
		jQuery( '.wpsse-license-result' ).html( '<div class="error"><p>Please enter Envato API Token</p></div>' );
		jQuery( '#licenceloader' ).hide();
		jQuery( '#licencetext' ).hide();
		jQuery( '#licence_submit' ).show();
		return false;
	}

		var data = {
			action: 'wpsse_' + action + '_license',
			api_key: jQuery( '#ws_envato' ).val(),
			wpnonce	: jQuery( '#_wpnonce' ).val()
	};
		jQuery.post(
			admin_ajax_object.ajaxurl,
			data,
			function ( response ) {
				var html;
				if ( ! response || parseInt( response ) === - 1 ) {
					html = 'Please enter valid Envato API Token';
				} else if ( response && response.message && response.result
				&& (String( response.result ) === '-3' || String( response.result ) === '-2'
				|| String( response.result ) === 'wp_error' || String( response.result ) === 'server_error') ) {
					html = response.message;
				} else if ( response && response.message && response.result && (String( response.result ) === '4') ) {
					html = response.message;
				} else {
					html = '';
				}
				jQuery( '.wpsse-license-result' ).html( html );
				jQuery( '#licenceloader' ).hide();
				jQuery( '#licencetext' ).hide();
				jQuery( '#licence_submit' ).show();
			},
			'json'
		)
			.always( function ( response ) {} );
}
function wpsseCopy( id, targetid ) {
	var copyText   = document.getElementById( id );
	var textArea   = document.createElement( "textarea" );
	textArea.value = copyText.textContent;
	document.body.appendChild( textArea );
	textArea.select();
	document.execCommand( "Copy" );
	textArea.remove();
}
