<?php

namespace Languages;

class Languages {
    public static $defaultLanguages = [
        'af' => [
            'code'             => 'af',
            'english'          => "Afrikaans",
            'local'            => "Afrikaans",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/za.svg',
            'square_flag_path' => 'flag-icon-css/1x1/za.svg',
            'variant'          => false,
        ],
        'am' => [
            'code'             => 'am',
            'english'          => "Amharic",
            'local'            => "አማርኛ",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/et.svg',
            'square_flag_path' => 'flag-icon-css/1x1/et.svg',
            'variant'          => false,
        ],
        'ar' => [
            'code'             => 'ar',
            'english'          => "Arabic",
            'local'            => "العربية‏",
            'rtl'              => true,
            'flag_path'        => 'flag-icon-css/4x3/sa.svg',
            'square_flag_path' => 'flag-icon-css/1x1/sa.svg',
            'variant'          => false,
        ],
        'az' => [
            'code'             => 'az',
            'english'          => "Azerbaijani",
            'local'            => "Azərbaycan dili",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/az.svg',
            'square_flag_path' => 'flag-icon-css/1x1/az.svg',
            'variant'          => false,
        ],
        'ba' => [
            'code'             => 'ba',
            'english'          => "Bashkir",
            'local'            => "башҡорт теле",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ru.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ru.svg',
            'variant'          => false,
        ],
        'be' => [
            'code'             => 'be',
            'english'          => "Belarusian",
            'local'            => "Беларуская",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/by.svg',
            'square_flag_path' => 'flag-icon-css/1x1/by.svg',
            'variant'          => false,
        ],
        'bg' => [
            'code'             => 'bg',
            'english'          => "Bulgarian",
            'local'            => "Български",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/bg.svg',
            'square_flag_path' => 'flag-icon-css/1x1/bg.svg',
            'variant'          => false,
        ],
        'bn' => [
            'code'             => 'bn',
            'english'          => "Bengali",
            'local'            => "বাংলা",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/bd.svg',
            'square_flag_path' => 'flag-icon-css/1x1/bd.svg',
            'variant'          => false,
        ],
        'br' => [
            'code'             => 'br',
            'english'          => "Brazilian Portuguese",
            'local'            => "Português Brasileiro",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/br.svg',
            'square_flag_path' => 'flag-icon-css/1x1/br.svg',
            'variant'          => false,
        ],
        'bs' => [
            'code'             => 'bs',
            'english'          => "Bosnian",
            'local'            => "Bosanski",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ba.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ba.svg',
            'variant'          => false,
        ],
        'ca' => [
            'code'             => 'ca',
            'english'          => "Catalan",
            'local'            => "Català",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/es-ca.svg',
            'square_flag_path' => 'flag-icon-css/1x1/es-ca.svg',
            'variant'          => false,
        ],
        'co' => [
            'code'             => 'co',
            'english'          => "Corsican",
            'local'            => "Corsu",
            'rtl'              => false,
            'flag_path'        => 'flags/4x3/fr-co.svg',
            'square_flag_path' => 'flags/1x1/fr-co.svg',
            'variant'          => false,
        ],
        'cs' => [
            'code'             => 'cs',
            'english'          => "Czech",
            'local'            => "Čeština",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/cz.svg',
            'square_flag_path' => 'flag-icon-css/1x1/cz.svg',
            'variant'          => false,
        ],
        'cy' => [
            'code'             => 'cy',
            'english'          => "Welsh",
            'local'            => "Cymraeg",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/gb-wls.svg',
            'square_flag_path' => 'flag-icon-css/1x1/gb-wls.svg',
            'variant'          => false,
        ],
        'da' => [
            'code'             => 'da',
            'english'          => "Danish",
            'local'            => "Dansk",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/dk.svg',
            'square_flag_path' => 'flag-icon-css/1x1/dk.svg',
            'variant'          => false,
        ],
        'de' => [
            'code'             => 'de',
            'english'          => "German",
            'local'            => "Deutsch",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/de.svg',
            'square_flag_path' => 'flag-icon-css/1x1/de.svg',
            'variant'          => false,
        ],
        'el' => [
            'code'             => 'el',
            'english'          => "Greek",
            'local'            => "Ελληνικά",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/gr.svg',
            'square_flag_path' => 'flag-icon-css/1x1/gr.svg',
            'variant'          => false,
        ],
        'en' => [
            'code'             => 'en',
            'english'          => "English",
            'local'            => "English",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/gb.svg',
            'square_flag_path' => 'flag-icon-css/1x1/gb.svg',
            'variant'          => false,
        ],
        'eo' => [
            'code'             => 'eo',
            'english'          => "Esperanto",
            'local'            => "Esperanto",
            'rtl'              => false,
            'flag_path'        => 'flags/4x3/eo.svg',
            'square_flag_path' => 'flags/1x1/eo.svg',
            'variant'          => false,
        ],
        'es' => [
            'code'             => 'es',
            'english'          => "Spanish",
            'local'            => "Español",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/es.svg',
            'square_flag_path' => 'flag-icon-css/1x1/es.svg',
            'variant'          => false,
        ],
        'et' => [
            'code'             => 'et',
            'english'          => "Estonian",
            'local'            => "Eesti",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ee.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ee.svg',
            'variant'          => false,
        ],
        'eu' => [
            'code'             => 'eu',
            'english'          => "Basque",
            'local'            => "Euskara",
            'rtl'              => false,
            'flag_path'        => 'flags/4x3/eu.svg',
            'square_flag_path' => 'flags/1x1/eu.svg',
            'variant'          => false,
        ],
        'fa' => [
            'code'             => 'fa',
            'english'          => "Persian",
            'local'            => "فارسی",
            'rtl'              => true,
            'flag_path'        => 'flag-icon-css/4x3/ir.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ir.svg',
            'variant'          => false,
        ],
        'fi' => [
            'code'             => 'fi',
            'english'          => "Finnish",
            'local'            => "Suomi",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/fi.svg',
            'square_flag_path' => 'flag-icon-css/1x1/fi.svg',
            'variant'          => false,
        ],
        'fj' => [
            'code'             => 'fj',
            'english'          => "Fijian",
            'local'            => "Vosa Vakaviti",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/fj.svg',
            'square_flag_path' => 'flag-icon-css/1x1/fj.svg',
            'variant'          => false,
        ],
        'fl' => [
            'code'             => 'fl',
            'english'          => "Filipino",
            'local'            => "Filipino",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ph.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ph.svg',
            'variant'          => false,
        ],
        'fr' => [
            'code'             => 'fr',
            'english'          => "French",
            'local'            => "Français",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/fr.svg',
            'square_flag_path' => 'flag-icon-css/1x1/fr.svg',
            'variant'          => false,
        ],
        'fy' => [
            'code'             => 'fy',
            'english'          => "Western Frisian",
            'local'            => "frysk",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/nl.svg',
            'square_flag_path' => 'flag-icon-css/1x1/nl.svg',
            'variant'          => false,
        ],
        'ga' => [
            'code'             => 'ga',
            'english'          => "Irish",
            'local'            => "Gaeilge",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ie.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ie.svg',
            'variant'          => false,
        ],
        'gd' => [
            'code'             => 'gd',
            'english'          => "Scottish Gaelic",
            'local'            => "Gàidhlig",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/gb-sct.svg',
            'square_flag_path' => 'flag-icon-css/1x1/gb-sct.svg',
            'variant'          => false,
        ],
        'gl' => [
            'code'             => 'gl',
            'english'          => "Galician",
            'local'            => "Galego",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/es-ga.svg',
            'square_flag_path' => 'flag-icon-css/1x1/es-ga.svg',
            'variant'          => false,
        ],
        'gu' => [
            'code'             => 'gu',
            'english'          => "Gujarati",
            'local'            => "ગુજરાતી",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/in.svg',
            'square_flag_path' => 'flag-icon-css/1x1/in.svg',
            'variant'          => false,
        ],
        'ha' => [
            'code'             => 'ha',
            'english'          => "Hausa",
            'local'            => "هَوُسَ",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ne.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ne.svg',
            'variant'          => false,
        ],
        'he' => [
            'code'             => 'he',
            'english'          => "Hebrew",
            'local'            => "עברית",
            'rtl'              => true,
            'flag_path'        => 'flag-icon-css/4x3/il.svg',
            'square_flag_path' => 'flag-icon-css/1x1/il.svg',
            'variant'          => false,
        ],
        'hi' => [
            'code'             => 'hi',
            'english'          => "Hindi",
            'local'            => "हिंदी",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/in.svg',
            'square_flag_path' => 'flag-icon-css/1x1/in.svg',
            'variant'          => false,
        ],
        'hr' => [
            'code'             => 'hr',
            'english'          => "Croatian",
            'local'            => "Hrvatski",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/hr.svg',
            'square_flag_path' => 'flag-icon-css/1x1/hr.svg',
            'variant'          => false,
        ],
        'ht' => [
            'code'             => 'ht',
            'english'          => "Haitian",
            'local'            => "Kreyòl ayisyen",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ht.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ht.svg',
            'variant'          => false,
        ],
        'hu' => [
            'code'             => 'hu',
            'english'          => "Hungarian",
            'local'            => "Magyar",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/hu.svg',
            'square_flag_path' => 'flag-icon-css/1x1/hu.svg',
            'variant'          => false,
        ],
        'hw' => [
            'code'             => 'hw',
            'english'          => "Hawaiian",
            'local'            => "‘Ōlelo Hawai‘i",
            'rtl'              => false,
            'flag_path'        => 'flags/4x3/hw.svg',
            'square_flag_path' => 'flags/1x1/hw.svg',
            'variant'          => false,
        ],
        'hy' => [
            'code'             => 'hy',
            'english'          => "Armenian",
            'local'            => "հայերեն",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/am.svg',
            'square_flag_path' => 'flag-icon-css/1x1/am.svg',
            'variant'          => false,
        ],
        'id' => [
            'code'             => 'id',
            'english'          => "Indonesian",
            'local'            => "Bahasa Indonesia",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/id.svg',
            'square_flag_path' => 'flag-icon-css/1x1/id.svg',
            'variant'          => false,
        ],
        'ig' => [
            'code'             => 'ig',
            'english'          => "Igbo",
            'local'            => "Igbo",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ne.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ne.svg',
            'variant'          => false,
        ],
        'is' => [
            'code'             => 'is',
            'english'          => "Icelandic",
            'local'            => "Íslenska",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/is.svg',
            'square_flag_path' => 'flag-icon-css/1x1/is.svg',
            'variant'          => false,
        ],
        'it' => [
            'code'             => 'it',
            'english'          => "Italian",
            'local'            => "Italiano",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/it.svg',
            'square_flag_path' => 'flag-icon-css/1x1/it.svg',
            'variant'          => false,
        ],
        'ja' => [
            'code'             => 'ja',
            'english'          => "Japanese",
            'local'            => "日本語",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/jp.svg',
            'square_flag_path' => 'flag-icon-css/1x1/jp.svg',
            'variant'          => false,
        ],
        'jv' => [
            'code'             => 'jv',
            'english'          => "Javanese",
            'local'            => "Wong Jawa",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/id.svg',
            'square_flag_path' => 'flag-icon-css/1x1/id.svg',
            'variant'          => false,
        ],
        'ka' => [
            'code'             => 'ka',
            'english'          => "Georgian",
            'local'            => "ქართული",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ge.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ge.svg',
            'variant'          => false,
        ],
        'kk' => [
            'code'             => 'kk',
            'english'          => "Kazakh",
            'local'            => "Қазақша",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/kz.svg',
            'square_flag_path' => 'flag-icon-css/1x1/kz.svg',
            'variant'          => false,
        ],
        'km' => [
            'code'             => 'km',
            'english'          => "Central Khmer",
            'local'            => "ភាសាខ្មែរ",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/kh.svg',
            'square_flag_path' => 'flag-icon-css/1x1/kh.svg',
            'variant'          => false,
        ],
        'kn' => [
            'code'             => 'kn',
            'english'          => "Kannada",
            'local'            => "ಕನ್ನಡ",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/in.svg',
            'square_flag_path' => 'flag-icon-css/1x1/in.svg',
            'variant'          => false,
        ],
        'ko' => [
            'code'             => 'ko',
            'english'          => "Korean",
            'local'            => "한국어",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/kr.svg',
            'square_flag_path' => 'flag-icon-css/1x1/kr.svg',
            'variant'          => false,
        ],
        'ku' => [
            'code'             => 'ku',
            'english'          => "Kurdish",
            'local'            => "كوردی",
            'rtl'              => true,
            'flag_path'        => 'flag-icon-css/4x3/iq.svg',
            'square_flag_path' => 'flag-icon-css/1x1/iq.svg',
            'variant'          => false,
        ],
        'ky' => [
            'code'             => 'ky',
            'english'          => "Kyrgyz",
            'local'            => "кыргызча",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/kg.svg',
            'square_flag_path' => 'flag-icon-css/1x1/kg.svg',
            'variant'          => false,
        ],
        'la' => [
            'code'             => 'la',
            'english'          => "Latin",
            'local'            => "Latine",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/it.svg',
            'square_flag_path' => 'flag-icon-css/1x1/it.svg',
            'variant'          => false,
        ],
        'lb' => [
            'code'             => 'lb',
            'english'          => "Luxembourgish",
            'local'            => "Lëtzebuergesch",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/lu.svg',
            'square_flag_path' => 'flag-icon-css/1x1/lu.svg',
            'variant'          => false,
        ],
        'lo' => [
            'code'             => 'lo',
            'english'          => "Lao",
            'local'            => "ພາສາລາວ",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/la.svg',
            'square_flag_path' => 'flag-icon-css/1x1/la.svg',
            'variant'          => false,
        ],
        'lt' => [
            'code'             => 'lt',
            'english'          => "Lithuanian",
            'local'            => "Lietuvių",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/lt.svg',
            'square_flag_path' => 'flag-icon-css/1x1/lt.svg',
            'variant'          => false,
        ],
        'lv' => [
            'code'             => 'lv',
            'english'          => "Latvian",
            'local'            => "Latviešu",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/lv.svg',
            'square_flag_path' => 'flag-icon-css/1x1/lv.svg',
            'variant'          => false,
        ],
        'lg' => [
            'code'             => 'lg',
            'english'          => "Luganda",
            'local'            => "Oluganda",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/mg.svg',
            'square_flag_path' => 'flag-icon-css/1x1/mg.svg',
            'variant'          => false,
        ],
        'mg' => [
            'code'             => 'mg',
            'english'          => "Malagasy",
            'local'            => "Malagasy",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/mg.svg',
            'square_flag_path' => 'flag-icon-css/1x1/mg.svg',
            'variant'          => false,
        ],
        'mi' => [
            'code'             => 'mi',
            'english'          => "Māori",
            'local'            => "te reo Māori",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/nz.svg',
            'square_flag_path' => 'flag-icon-css/1x1/nz.svg',
            'variant'          => false,
        ],
        'mk' => [
            'code'             => 'mk',
            'english'          => "Macedonian",
            'local'            => "Македонски",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/mk.svg',
            'square_flag_path' => 'flag-icon-css/1x1/mk.svg',
            'variant'          => false,
        ],
        'ml' => [
            'code'             => 'ml',
            'english'          => "Malayalam",
            'local'            => "മലയാളം",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/in.svg',
            'square_flag_path' => 'flag-icon-css/1x1/in.svg',
            'variant'          => false,
        ],
        'mn' => [
            'code'             => 'mn',
            'english'          => "Mongolian",
            'local'            => "Монгол",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/mn.svg',
            'square_flag_path' => 'flag-icon-css/1x1/mn.svg',
            'variant'          => false,
        ],
        'mr' => [
            'code'             => 'mr',
            'english'          => "Marathi",
            'local'            => "मराठी",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/in.svg',
            'square_flag_path' => 'flag-icon-css/1x1/in.svg',
            'variant'          => false,
        ],
        'ms' => [
            'code'             => 'ms',
            'english'          => "Malay",
            'local'            => "Bahasa Melayu",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/my.svg',
            'square_flag_path' => 'flag-icon-css/1x1/my.svg',
            'variant'          => false,
        ],
        'mt' => [
            'code'             => 'mt',
            'english'          => "Maltese",
            'local'            => "Malti",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/mt.svg',
            'square_flag_path' => 'flag-icon-css/1x1/mt.svg',
            'variant'          => false,
        ],
        'my' => [
            'code'             => 'my',
            'english'          => "Burmese",
            'local'            => "မျန္မာစာ",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/mm.svg',
            'square_flag_path' => 'flag-icon-css/1x1/mm.svg',
            'variant'          => false,
        ],
        'ne' => [
            'code'             => 'ne',
            'english'          => "Nepali",
            'local'            => "नेपाली",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/np.svg',
            'square_flag_path' => 'flag-icon-css/1x1/np.svg',
            'variant'          => false,
        ],
        'nl' => [
            'code'             => 'nl',
            'english'          => "Dutch",
            'local'            => "Nederlands",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/nl.svg',
            'square_flag_path' => 'flag-icon-css/1x1/nl.svg',
            'variant'          => false,
        ],
        'no' => [
            'code'             => 'no',
            'english'          => "Norwegian",
            'local'            => "Norsk",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/no.svg',
            'square_flag_path' => 'flag-icon-css/1x1/no.svg',
            'variant'          => false,
        ],
        'ny' => [
            'code'             => 'ny',
            'english'          => "Chichewa",
            'local'            => "chiCheŵa",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/mw.svg',
            'square_flag_path' => 'flag-icon-css/1x1/mw.svg',
            'variant'          => false,
        ],
        'pa' => [
            'code'             => 'pa',
            'english'          => "Punjabi",
            'local'            => "ਪੰਜਾਬੀ",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/in.svg',
            'square_flag_path' => 'flag-icon-css/1x1/in.svg',
            'variant'          => false,
        ],
        'pl' => [
            'code'             => 'pl',
            'english'          => "Polish",
            'local'            => "Polski",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/pl.svg',
            'square_flag_path' => 'flag-icon-css/1x1/pl.svg',
            'variant'          => false,
        ],
        'ps' => [
            'code'             => 'ps',
            'english'          => "Pashto",
            'local'            => "پښت",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/af.svg',
            'square_flag_path' => 'flag-icon-css/1x1/af.svg',
            'variant'          => false,
        ],
        'pt' => [
            'code'             => 'pt',
            'english'          => "Portuguese",
            'local'            => "Português",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/pt.svg',
            'square_flag_path' => 'flag-icon-css/1x1/pt.svg',
            'variant'          => false,
        ],
        'ro' => [
            'code'             => 'ro',
            'english'          => "Romanian",
            'local'            => "Română",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ro.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ro.svg',
            'variant'          => false,
        ],
        'ru' => [
            'code'             => 'ru',
            'english'          => "Russian",
            'local'            => "Русский",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ru.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ru.svg',
            'variant'          => false,
        ],
        'sd' => [
            'code'             => 'sd',
            'english'          => "Sindhi",
            'local'            => "سنڌي، سندھی, सिन्धी",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/pk.svg',
            'square_flag_path' => 'flag-icon-css/1x1/pk.svg',
            'variant'          => false,
        ],
        'si' => [
            'code'             => 'si',
            'english'          => "Sinhalese",
            'local'            => "සිංහල",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/lk.svg',
            'square_flag_path' => 'flag-icon-css/1x1/lk.svg',
            'variant'          => false,
        ],
        'sk' => [
            'code'             => 'sk',
            'english'          => "Slovak",
            'local'            => "Slovenčina",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/sk.svg',
            'square_flag_path' => 'flag-icon-css/1x1/sk.svg',
            'variant'          => false,
        ],
        'sl' => [
            'code'             => 'sl',
            'english'          => "Slovenian",
            'local'            => "Slovenščina",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/si.svg',
            'square_flag_path' => 'flag-icon-css/1x1/si.svg',
            'variant'          => false,
        ],
        'sm' => [
            'code'             => 'sm',
            'english'          => "Samoan",
            'local'            => "gagana fa'a Samoa",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ws.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ws.svg',
            'variant'          => false,
        ],
        'sn' => [
            'code'             => 'sn',
            'english'          => "Shona",
            'local'            => "chiShona",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/zw.svg',
            'square_flag_path' => 'flag-icon-css/1x1/zw.svg',
            'variant'          => false,
        ],
        'so' => [
            'code'             => 'so',
            'english'          => "Somali",
            'local'            => "Soomaaliga",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/so.svg',
            'square_flag_path' => 'flag-icon-css/1x1/so.svg',
            'variant'          => false,
        ],
        'sq' => [
            'code'             => 'sq',
            'english'          => "Albanian",
            'local'            => "Shqip",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/al.svg',
            'square_flag_path' => 'flag-icon-css/1x1/al.svg',
            'variant'          => false,
        ],
        'sr' => [
            'code'             => 'sr',
            'english'          => "Serbian (Cyrillic)",
            'local'            => "Српски",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/rs.svg',
            'square_flag_path' => 'flag-icon-css/1x1/rs.svg',
            'variant'          => false,
        ],
        'st' => [
            'code'             => 'st',
            'english'          => "Southern Sotho",
            'local'            => "seSotho",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ng.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ng.svg',
            'variant'          => false,
        ],
        'su' => [
            'code'             => 'su',
            'english'          => "Sundanese",
            'local'            => "Sundanese",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/sd.svg',
            'square_flag_path' => 'flag-icon-css/1x1/sd.svg',
            'variant'          => false,
        ],
        'sv' => [
            'code'             => 'sv',
            'english'          => "Swedish",
            'local'            => "Svenska",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/se.svg',
            'square_flag_path' => 'flag-icon-css/1x1/se.svg',
            'variant'          => false,
        ],
        'sw' => [
            'code'             => 'sw',
            'english'          => "Swahili",
            'local'            => "Kiswahili",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ke.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ke.svg',
            'variant'          => false,
        ],
        'ta' => [
            'code'             => 'ta',
            'english'          => "Tamil",
            'local'            => "தமிழ்",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/in.svg',
            'square_flag_path' => 'flag-icon-css/1x1/in.svg',
            'variant'          => false,
        ],
        'te' => [
            'code'             => 'te',
            'english'          => "Telugu",
            'local'            => "తెలుగు",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/in.svg',
            'square_flag_path' => 'flag-icon-css/1x1/in.svg',
            'variant'          => false,
        ],
        'tg' => [
            'code'             => 'tg',
            'english'          => "Tajik",
            'local'            => "Тоҷикӣ",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/tj.svg',
            'square_flag_path' => 'flag-icon-css/1x1/tj.svg',
            'variant'          => false,
        ],
        'th' => [
            'code'             => 'th',
            'english'          => "Thai",
            'local'            => "ภาษาไทย",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/th.svg',
            'square_flag_path' => 'flag-icon-css/1x1/th.svg',
            'variant'          => false,
        ],
        'tl' => [
            'code'             => 'tl',
            'english'          => "Tagalog",
            'local'            => "Tagalog",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/in.svg',
            'square_flag_path' => 'flag-icon-css/1x1/in.svg',
            'variant'          => false,
        ],
        'to' => [
            'code'             => 'to',
            'english'          => "Tongan",
            'local'            => "faka-Tonga",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/to.svg',
            'square_flag_path' => 'flag-icon-css/1x1/to.svg',
            'variant'          => false,
        ],
        'tr' => [
            'code'             => 'tr',
            'english'          => "Turkish",
            'local'            => "Türkçe",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/tr.svg',
            'square_flag_path' => 'flag-icon-css/1x1/tr.svg',
            'variant'          => false,
        ],
        'tt' => [
            'code'             => 'tt',
            'english'          => "Tatar",
            'local'            => "Tatar",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/tr.svg',
            'square_flag_path' => 'flag-icon-css/1x1/tr.svg',
            'variant'          => false,
        ],
        'tw' => [
            'code'             => 'tw',
            'english'          => "Traditional Chinese",
            'local'            => "中文 (繁體)",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/tw.svg',
            'square_flag_path' => 'flag-icon-css/1x1/tw.svg',
            'variant'          => false,
        ],
        'ty' => [
            'code'             => 'ty',
            'english'          => "Tahitian",
            'local'            => "te reo Tahiti, te reo Māʼohi",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/pf.svg',
            'square_flag_path' => 'flag-icon-css/1x1/pf.svg',
            'variant'          => false,
        ],
        'uk' => [
            'code'             => 'uk',
            'english'          => "Ukrainian",
            'local'            => "Українська",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ua.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ua.svg',
            'variant'          => false,
        ],
        'ur' => [
            'code'             => 'ur',
            'english'          => "Urdu",
            'local'            => "اردو",
            'rtl'              => true,
            'flag_path'        => 'flag-icon-css/4x3/pk.svg',
            'square_flag_path' => 'flag-icon-css/1x1/pk.svg',
            'variant'          => false,
        ],
        'uz' => [
            'code'             => 'uz',
            'english'          => "Uzbek",
            'local'            => "O'zbek",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/uz.svg',
            'square_flag_path' => 'flag-icon-css/1x1/uz.svg',
            'variant'          => false,
        ],
        'vi' => [
            'code'             => 'vi',
            'english'          => "Vietnamese",
            'local'            => "Tiếng Việt",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/vn.svg',
            'square_flag_path' => 'flag-icon-css/1x1/vn.svg',
            'variant'          => false,
        ],
        'xh' => [
            'code'             => 'xh',
            'english'          => "Xhosa",
            'local'            => "isiXhosa",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/za.svg',
            'square_flag_path' => 'flag-icon-css/1x1/za.svg',
            'variant'          => false,
        ],
        'yi' => [
            'code'             => 'yi',
            'english'          => "Yiddish",
            'local'            => "ייִדיש",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/il.svg',
            'square_flag_path' => 'flag-icon-css/1x1/il.svg',
            'variant'          => false,
        ],
        'yo' => [
            'code'             => 'yo',
            'english'          => "Yoruba",
            'local'            => "Yorùbá",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ng.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ng.svg',
            'variant'          => false,
        ],
        'zh' => [
            'code'             => 'zh',
            'english'          => "Simplified Chinese",
            'local'            => "中文 (简体)",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/cn.svg',
            'square_flag_path' => 'flag-icon-css/1x1/cn.svg',
            'variant'          => false,
        ],
        'zu' => [
            'code'             => 'zu',
            'english'          => "Zulu",
            'local'            => "isiZulu",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/za.svg',
            'square_flag_path' => 'flag-icon-css/1x1/za.svg',
            'variant'          => false,
        ],
        'hm' => [
            'code'             => 'hm',
            'english'          => "Hmong",
            'local'            => "Hmoob",
            'rtl'              => false,
            'flag_path'        => 'flags/4x3/hm.svg',
            'square_flag_path' => 'flags/1x1/hm.svg',
            'variant'          => false,
        ],
        'cb' => [
            'code'             => 'cb',
            'english'          => "Cebuano",
            'local'            => "Sugbuanon",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/ph.svg',
            'square_flag_path' => 'flag-icon-css/1x1/ph.svg',
            'variant'          => false,
        ],
        'or' => [
            'code'             => 'or',
            'english'          => "Odia",
            'local'            => "ଓଡ଼ିଆ",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/in.svg',
            'square_flag_path' => 'flag-icon-css/1x1/in.svg',
            'variant'          => false,
        ],
        'tk' => [
            'code'             => 'tk',
            'english'          => "Turkmène",
            'local'            => "Türkmen",
            'rtl'              => false,
            'flag_path'        => 'flag-icon-css/4x3/tr.svg',
            'square_flag_path' => 'flag-icon-css/1x1/tr.svg',
            'variant'          => false,
        ],
        'ug' => [
            'code'             => 'ug',
            'english'          => "Uyghur",
            'local'            => "ئۇيغۇر",
            'rtl'              => true,
            'flag_path'        => 'flags/4x3/ug.svg',
            'square_flag_path' => 'flags/1x1/ug.svg',
            'variant'          => false,
        ],
        'fc' => [
            'code'             => 'fc',
            'english'          => "French (Canada)",
            'local'            => "Français (Canada)",
            'rtl'              => false,
            'flag_path'        => 'flags/4x3/ca.svg',
            'square_flag_path' => 'flags/1x1/ca.svg',
            'variant'          => true,
        ],
        'as' => [
            'code'             => 'as',
            'english'          => "Assamese",
            'local'            => "অসমীয়া",
            'rtl'              => false,
            'flag_path'        => 'flags/4x3/in.svg',
            'square_flag_path' => 'flags/1x1/in.svg',
            'variant'          => false,
        ],
        'sa' => [
            'code'             => 'sa',
            'english'          => "Serbian (Latin)",
            'local'            => "Srpski",
            'rtl'              => false,
            'flag_path'        => 'flags/4x3/rs.svg',
            'square_flag_path' => 'flags/1x1/rs.svg',
            'variant'          => false,
        ]
    ];
}
